require 'test_helper'

class ToolAuthsControllerTest < ActionController::TestCase
  setup do
    @tool_auth = tool_auths(:one)
    @request.env['HTTP_REFERER'] = 'http://localhost:3000/tool_auths/new'
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:tool_auths)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  ##############REDMINE
  test "should not create tool_auth, incorrect key, redmine" do
    assert_no_difference('ToolAuth.count') do
      post :create, tool_auth: { api_key: 'f8cf0209e388495372c7a37cdd3849089b3744f',  password: '', url: 'https://www.hostedredmine.com', tool_user: '', user_id: '1', tool_name: 'redmine' }
    end
  end

  test "should not create tool_auth, incorrect url, redmine" do
    assert_no_difference('ToolAuth.count') do
      post :create, tool_auth: { api_key: 'f8cf0209e388495372c7a37cdd3849089b3744f5',  password: '', url: 'https://www.hostedredmine.co', tool_user: '', user_id: '1', tool_name: 'redmine' }
    end

  end

  test "should create tool_auth redmine" do
    assert_difference('ToolAuth.count') do
      post :create, tool_auth: { api_key: 'f8cf0209e388495372c7a37cdd3849089b3744f5',  password: '', url: 'https://www.hostedredmine.com', tool_user: '', user_id: '1', tool_name: 'redmine' }
    end

    assert_redirected_to tool_auths_path
  end

  test "should not create tool_auth, url with blanks, redmine" do
    assert_no_difference('ToolAuth.count') do
      post :create, tool_auth: { api_key: 'f8cf0209e388495372c7a37cdd3849089b3744f5',  password: '', url: 'https://www.hostedredmine.com ', tool_user: '', user_id: '1', tool_name: 'redmine' }
    end

  end

  ############FIN REDMINE

  ####JIRA
  test "should_not_create_tool_auth_wrong_url jira" do
    assert_no_difference('ToolAuth.count') do
      post :create, tool_auth: { api_key: '', password: 'PIS2013', url: 'https://pis2013.atlassian.com', tool_user: 'admin', user_id: '1', tool_name: 'jira' }
    end
  end

  test "should_not_create_tool_auth_wrong_password jira" do
    assert_no_difference('ToolAuth.count') do
      post :create, tool_auth: { api_key: '', password: 'MAL', url: 'https://pis2013.atlassian.net', tool_user: 'admin', user_id: '1', tool_name: 'jira' }
    end
  end

  ########FIN JIRA

  test "should show tool_auth" do
    get :show, id: @tool_auth
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @tool_auth
    assert_response :success
  end

  test "should update tool_auth" do
    patch :update, id: @tool_auth, tool_auth: { api_key: @tool_auth.api_key, password: @tool_auth.password, url: @tool_auth.url, tool_user: @tool_auth.tool_user, user_id: @tool_auth.user_id }
    assert_redirected_to tool_auth_path(assigns(:tool_auth))
  end

  test "should destroy tool_auth" do
    assert_difference('ToolAuth.count', -1) do
      delete :destroy, id: @tool_auth
    end

    assert_redirected_to tool_auths_path
  end
end
