ENV["RAILS_ENV"] ||= "test"
require File.expand_path('../../config/environment', __FILE__)
require 'rails/test_help'

#para reportes en Rubymine
require 'minitest/reporters'
MiniTest::Reporters.use!

class ActiveSupport::TestCase
  ActiveRecord::Migration.check_pending!

  # Setup all fixtures in test/fixtures/*.yml for all tests in alphabetical order.
  #
  # Note: You'll currently still have to declare fixtures explicitly in integration tests
  # -- they do not yet inherit this setting
  fixtures :all

  # Add more helper methods to be used by all tests here...

  OmniAuth.config.test_mode = true
  omniauth_hash = { 'provider' => 'google_oauth2',
                    'uid' => '12345',
                    'info' => {
                        'name' => 'admin',
                        'email' => 'admin@admin.com',
                        'nickname' => 'admin'
                    }
                  }
  OmniAuth.config.add_mock(:google_oauth2, omniauth_hash)

  #Simulamos el login de un admin, entrando al controller de session y creando una sesion.
  def  login_admin
    request.env['omniauth.auth'] = OmniAuth.config.mock_auth[:google_oauth2]
    old_controller = @controller
    @controller = SessionsController.new
    post :create, provider: :google_oauth2
    @controller = old_controller
  end
end

