require 'test/unit'
require_relative '../../lib/JiraClient.rb'
require 'test_helper.rb'

class Test_JiraClient < Test::Unit::TestCase

  def setup
    @user = 'toombs'
    @pass = 'PIS2013'
    @site = 'https://toombs.atlassian.net'
  end

  def	test_initialize()
    assert_not_nil(JiraClient.new(@user,@pass,@site))
  end

  def test_doAuthentication_Ok()
    myClient = JiraClient.new(@user,@pass,@site)
    assert(myClient.doAuthentication().empty?)
  end

  def test_doAuthentication_ErrorIncorrectURL()
    myClient = JiraClient.new(@user,@pass,'https://pis2013.atlassian.ne')
    error = 'URL incorrect.'
    assert_equal(error,myClient.doAuthentication())
  end

  def test_doAuthentication_ErrorIncorrectProtocol()
    myClient = JiraClient.new(@user,@pass,'www.facebook.com')
    error = 'URL incorrect.'
    assert_equal(error,myClient.doAuthentication())
  end

  def test_doAuthentication_ErrorAuthInfoIncorrect()
    myClient = JiraClient.new('prueba','pass',@site)
    error = 'User or Password incorrect.'
    assert_equal(error,myClient.doAuthentication())
  end

  def test_getProjects()
    myClient = JiraClient.new(@user,@pass,@site)
    message = myClient.doAuthentication()
    projects = myClient.getProjects()
    count = projects.length
    assert_equal(2, count)
  end

  def test_getUserIssues()
    myClient = JiraClient.new(@user,@pass,@site)
    message = myClient.doAuthentication()
    issues = myClient.getUserIssues()
    count = issues.length
    assert_equal(7, count)
  end

  def test_getIssue_Ok()
    myClient = JiraClient.new(@user,@pass,@site)
    message1 = myClient.doAuthentication()
    issue, message = myClient.getIssue(10103)
    assert_equal('',message)
  end

  def test_getIssue_Error()
    myClient = JiraClient.new(@user,@pass,@site)
    message1 = myClient.doAuthentication()
    issue, message = myClient.getIssue(10100000)
    assert_equal('Task with ID: 10100000 does not exist.',message)
  end

  def test_createWorklog_Ok()
    myClient = JiraClient.new(@user,@pass,@site)
    message = myClient.doAuthentication()
    comentario = 'Testing createWorklog function.'
    worklog = myClient.createWorklog(10103,comentario,Time.parse('2013-09-21'),'2:00')
    assert_equal('Successful entry.',worklog)
  end

  def test_createWorklog_Error()
    myClient = JiraClient.new(@user,@pass,@site)
    message = myClient.doAuthentication()
    comentario = 'Testing createWorklog function.'
    worklog = myClient.createWorklog(10100000,comentario,Time.parse('2013-09-21'),'2:00')
    assert_equal('Task with ID: 10100000 does not exist.',worklog)
  end

  def test_editJiraIssue_nextStatus_getPriorities()
    myClient = JiraClient.new(@user,@pass,@site)
    message = myClient.doAuthentication()
    issue,message = myClient.getIssue(10103)
    status_names = myClient.getNextStatus('10103')
    priorities = myClient.getPriorities()
    task = Task.new
    task.externalId = issue.id
    task.description = 'Testing editJiraIssue 2'
    task.due_date = Time.new().strftime('%Y-%m-%d')
    task.name = 'Test Editar Issue 2'
    task.priority = priorities[1].to_s
    task.status = status_names[1].to_s
    task.estimation = '36h'
    mensaje = myClient.editJiraIssue(task)
    assert_equal('',mensaje)
  end

  def test_getNextStatus()
    myClient = JiraClient.new(@user,@pass,@site)
    message = myClient.doAuthentication()
    assert_not_equal([],myClient.getNextStatus(10103))
  end

  def test_getPriorities()
    myClient = JiraClient.new(@user,@pass,@site)
    message = myClient.doAuthentication()
    assert_not_equal([],myClient.getPriorities())
  end
end