require 'test/unit'
require 'rubygems'
require_relative '../../lib/RedMineClient.rb'
require 'test_helper.rb'


class TestRedMineClient < Test::Unit::TestCase


  # Called before every test method runs. Can be used
  # to set up fixture information.
  def setup
    @api_key_Right = 'f8cf0209e388495372c7a37cdd3849089b3744f5'              # usuario: Gisel
    @api_key_test = 'ecb578310502fd3c21a8c315259b2926417ea7b4'               # usuario: usuario_test asociado solo al proyecto RedMineTest
    @api_Key_Wrong = 'f8cf0209e388495372c7a37cdd3849089b3744f'
    @base_uri = "www.hostedredmine.com"
    @base_uri_Wrong = 'www.hostredmine.com'
  end

  def test_doAuthentication_OK()
    myClient = RedMineClient.new(@api_key_test,@base_uri)
    message = myClient.doAuthentication()
    assert_equal('',message)
  end

  def test_doAuthentication_Error_User()
    myClient = RedMineClient.new(@api_Key_Wrong,@base_uri)
    message = myClient.doAuthentication()
    assert_equal("User doesn't exist",message)
  end

  def test_doAuthentication_Error_Url()
    myClient = RedMineClient.new(@api_Key_test,@base_uri_Wrong)
    message = myClient.doAuthentication()
    assert_equal("Error validating credentials.",message)
  end

  def test_doAuthentication_Error_Url_User()
    myClient = RedMineClient.new(@api_Key_Wrong,@base_uri_Wrong)
    message = myClient.doAuthentication()
    assert_equal("Connection ERROR",message)
  end

  def test_getProjects()
    myClient = RedMineClient.new(@api_key_test,@base_uri)
    assert_equal(1,myClient.getProjects().length)
  end

  def test_import_issues()
    myClient = RedMineClient.new(@api_key_Right,@base_uri)
    assert_not_equal('Connection ERROR',myClient.getIssuesUser)     #se prueba doble iteracion del while
    myClient2=RedMineClient.new(@api_key_test,@base_uri)
    assert_not_equal('Connection ERROR',myClient2.getIssuesUser)
  end

  def test_import_issues_error_key()
    myClient = RedMineClient.new(@api_Key_Wrong,@base_uri)
    message = myClient.doAuthentication()
    assert_equal("User doesn't exist",message)
  end

  #Creates multiple time entries
  def test_multiple_Time_Entries
    myClient = RedMineClient.new(@api_key_test,@base_uri)
    time_now = Time.new().strftime("%Y-%m-%dT%H:%M:%S.000%z")
    i = 1
    while i < 30
      assert_not_equal(422,myClient.create_Time_Entry("218380",time_now,"1","9","prueba" + i.to_s))
      i = i + 1
    end
  end

  #Creates a Time_Entrie con hora = 0
  def test_Entries_zero
    myClient = RedMineClient.new(@api_key_test,@base_uri)

    assert_not_equal(422,myClient.create_Time_Entry("218380",Time.new().strftime("%Y-%m-%dT%H:%M:%S.000%z"),"0","9","pruebaTimeEntry 0" ))

  end

  #Creates a Time_Entrie con hora = 100
  def test_Entries_hundred
    myClient = RedMineClient.new(@api_key_test,@base_uri)

    assert_not_equal(422,myClient.create_Time_Entry("218380",Time.new().strftime("%Y-%m-%dT%H:%M:%S.000%z"),"100","9","pruebaTimeEntry 100" ))

  end

  #Creates a Time_Entrie con activiti_Id = 0
  def test_Entries_Activity_zero
    myClient = RedMineClient.new(@api_key_test,@base_uri)

    assert_not_equal(422,myClient.create_Time_Entry("218380",Time.new().strftime("%Y-%m-%dT%H:%M:%S.000%z"),"0.5","0","pruebaTimeEntry Activity 0" ))

  end


  def test_edit_issue
    myClient = RedMineClient.new(@api_key_Right,@base_uri)
    status= myClient.getNextStatus("220413")
    status= status.split(';')
    priority= myClient.getPriorities()
    priority= priority.split(';')
    task = Task.new()
    task.externalId = "220413"
    task.description = 'Testing editJiraIssue'
    task.due_date = Time.new().strftime('%Y-%m-%d')
    task.name = 'Test Editar Issue 2'
    task.priority = priority[1].to_s
    task.status = status[1].to_s
    task.estimation = '36h'
    mensaje = myClient.editRedMineIssue(task)
    assert_equal('',mensaje)

  end

  #Creates a Time_Entrie con hora  = 05
  def test_Entries_hora_05
    myClient = RedMineClient.new(@api_key_test,@base_uri)

    assert_not_equal(422,myClient.create_Time_Entry("218380",Time.new().strftime("%Y-%m-%dT%H:%M:%S.000%z"),"05","9","pruebaTimeEntry 05" ))


  end

  #Creates a Time_Entrie comment empty
  def test_Entries_comment_empty
    myClient = RedMineClient.new(@api_key_test,@base_uri)

    assert_not_equal(422,myClient.create_Time_Entry("218380",Time.new().strftime("%Y-%m-%dT%H:%M:%S.000%z"),"05","9","" ))

  end

end