package brick.utils;

import java.util.EmptyQueueException;
import java.util.Vector;
/*
* $Log: Queue.java,v $
* Revision 1.2  2005/11/23 17:46:45  mpscholz
* minor javadoc related changes
*
* Revision 1.1  2003/08/17 14:59:42  mpscholz
* enhanced Vector
* added Stack and Queue and associated exception classes
*
*/

/////////////////////////////////////////////////////////
/**
 * A FIFO Queue of objects. 
 */
public class Queue<E> extends Vector<E> {
	
	//TODO in JDK, java.util.Queue is an interface

	////////////////////////////////////////////
	// constants
	////////////////////////////////////////////
    
	////////////////////////////////////////////
	// fields
	////////////////////////////////////////////

	////////////////////////////////////////////
	// constructors
	////////////////////////////////////////////

	////////////////////////////////////////////
    /**
     * creates a new Queue instance
     */
    public Queue() {
    	// do nothing
    } // Queue()

	////////////////////////////////////////////
	/**
	 * pushes an object onto the Queue
	 * @param anObject the object
	 * @return Object the object pushed onto the Queue
	 */
    public E push(E anObject) {
    	// add the object to base vector
		addElement(anObject);
		return anObject;
    } // push()

	////////////////////////////////////////////
	/**
	 * fetches an object from the start of the Queue
	 * and removes it
	 * @return Object the object removed from the start of the stock
	 * @throws EmptyQueueException
	 */
    public synchronized E pop() throws EmptyQueueException {
		// get object
		E popped = peek();
		// remove and return object
		removeElementAt(0);
		return popped;
    } // pop()

	////////////////////////////////////////////
	/**
	 * fetches an object from the start of the Queue
	 * <br>does not remove it!
	 * @return Object the object at the start of the Queue
	 * @throws EmptyQueueException
	 */
    public synchronized E peek() throws EmptyQueueException {
		// empty Queue?
		if(size()==0)
	    	throw new EmptyQueueException();
	    // return first element
		return elementAt(0);
    } // peek()

	////////////////////////////////////////////
	/**
	 * is this Queue empty?
	 * @return boolean true, if the Queue is empty
	 */
    public boolean empty() {
		return (size()==0);
    } // empty()

} // class Queue

