/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc.basicStructures;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.machine.Machine;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOUBLE
extends AbstractBasicData<Double> {
    public DOUBLE(double value) {
        super(value);
        try {
            this.createPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getSizeOf() {
        return DOUBLE.sizeOf();
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(DOUBLE.sizeOf()));
        this.pointer.setDoubleAt(0, (Double)this.mValue);
        return this.pointer;
    }

    @Override
    public Double getValueFromPointer() throws NativeException {
        this.mValue = this.pointer.getAsDouble(0);
        return (Double)this.mValue;
    }

    public void setValue(double lValue) throws NativeException {
        this.mValue = lValue;
        this.pointer.setDoubleAt(0, (Double)this.mValue);
    }

    @Override
    public Double getValue() {
        try {
            return this.getValueFromPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static int sizeOf() {
        return Machine.SIZE * 8;
    }
}

