package linkscript;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

import logica.HexFile;
import logica.HexRecord;

import org.pgusb.usbDllAdapter.UsbDllAdapter;

import boot.BootLoader;
import exceptions.ParseHexRecordException;

public class LinkScriptParser {
	//codepages
	public static final String USB_ENDPOINTS_INIT_SEC_LABEL = "usb_endpoints_init_sec";
	public static final String DEVICE_DSC_SEC = "device_dsc_sec";
	public static final String USB_CD_PTR_SEC = "usb_cd_ptr_sec";
	public static final String USB_SD_PTR_SEC = "usb_sd_ptr_sec";
	//sections
	public static final String USB_ENDPOINTS_INIT = "_usb_endpoints_init";
	public static final String DEVICE_DSC = "_device_dsc";
	public static final String USB_CD_PTR = "_usb_cd_ptr";
	public static final String USB_SD_PTR = "_usb_sd_ptr";
	 
	private Vector<String> sectionsNecesarias;
	private HashMap<String,Codepage> codepages;
	private HashMap<String,Section> sections;

	public HashMap<String, Codepage> getCodepages() {
		return codepages;
	}

	public void setCodepages(HashMap<String, Codepage> codepages) {
		this.codepages = codepages;
	}
	public LinkScriptParser(){
		codepages = new HashMap<String,Codepage>();
		sections = new HashMap<String,Section>();
		//agregar las necesarias
		sectionsNecesarias = new Vector<String>();
		sectionsNecesarias.add(USB_ENDPOINTS_INIT);
		sectionsNecesarias.add(DEVICE_DSC);
		sectionsNecesarias.add(USB_CD_PTR);
		sectionsNecesarias.add(USB_SD_PTR);
	}
	
	public void parseFromFile(String filename){
		try {
			/*
			 * Sets up a file reader to read the file passed on the
			 * command line one character at a time
			 */
			FileReader input = new FileReader(filename);
			
			/*
			 * Filter FileReader through a Buffered read to read a line
			 * at a time
			 */
			BufferedReader bufRead = new BufferedReader(input);
			
			String line;    // String that holds current file line
			int count = 0;  // Line number of count
			
			// Read first line
			boolean termine = false;
			count++;
			// Read through file one line at time. Print line #
			// and line
			HexFile hf = new HexFile();
			while (!termine){
				line = bufRead.readLine();
				if (line!=null){
					//proceso la linea
					//paso 1) ignoro lo que viene despuesde "//"
					//System.out.println("el index of es :" + line.indexOf("//"));
					int posComment = line.indexOf("//");
					if (posComment!=-1){ //chequeo si tiene comentario
						if (posComment!=0){ 
							line = line.substring(0,posComment); //si tiene y no es al principio, me quedo con la linea hasta el comentario
							System.out.println("line sin comentario:" + line);
						}
						else line = "";
					}
					//paso 2 busco si la linea tiene un codepage o un section
					//TODO emprolijar el parseo
					if (line.contains("CODEPAGE") || line.contains("codepage")){
						//System.out.println("es un codepage!!!");
						Codepage c = new Codepage();
						c.parse(line);
						codepages.put(c.getName(),c);
					}
					if (line.contains("SECTION") || line.contains("section")){
						
						//System.out.println("es un codepage!!!");
						Section s = new Section(this);
						s.parse(line);
						sections.put(s.getName(),s);
					}
					
				}
				else termine=true;
			}
			
			bufRead.close();
			
		}catch (IOException e){
			// If another exception is generated, print a stack
			// trace
			e.printStackTrace();
		}
	}
	public int getStartAddress(String section){
		if (sections.containsKey(section)){
			return sections.get(section).getCodepageStart();
		}
		return -1;
	}
	public int getEndAddress(String section){
		if (sections.containsKey(section)){
			return sections.get(section).getCodepageEnd();
		}
		return -1;
	}
}
