import usb4allConfigGenerator.Configuration;
import usb4allConfigGenerator.DeviceDescriptor;
import usb4allConfigGenerator.Endpoint;
import usb4allConfigGenerator.Interface;
import usb4allConfigGenerator.StringDescriptor;
import usb4allConfigGenerator.Usb4allConfigGenerator;

public class testConfigGenerator {

	/**
	 * @param args
	 */
	//	por ahora genera bien con endpoints bulk e int, ppbuffering 0 una cfg y una interface
	
	public static void main(String[] args) {
		// TODO falta pingpong buffer, varias cfg, varias interfaces, y ep control e iso
		DeviceDescriptor dd = new DeviceDescriptor(2,0,0,0,8,0x04D8,0x000C,0);
		
		//genero string descriptors
		StringDescriptor sd0 = new StringDescriptor(0x0409);
		StringDescriptor sd1 = new StringDescriptor("Aguirre Fernandez Grossy");
		StringDescriptor sd2 = new StringDescriptor("USB4all (C)2007");
		StringDescriptor sd3 = new StringDescriptor("12345678");		

		//los asigno al device descriptor
		dd.addStringDescriptor(sd0);
		dd.addStringDescriptor(sd1);
		dd.addStringDescriptor(sd2);
		dd.addStringDescriptor(sd3);
		
		//asigno strings de manofacturer y product
		dd.setManufacturerString(sd1);
		dd.setProductString(sd2);
		dd.setDeviceSerialNumberString(sd3);
		//creo configuracion 1
		Configuration cfg1 = new Configuration(dd,50);
		
		//creo endpoints
		Endpoint ep1out = new Endpoint(1, Endpoint.OUT,Endpoint.INTERRUPT, 64, 32);
		Endpoint ep1in =  new Endpoint(1, Endpoint.IN,Endpoint.INTERRUPT, 64, 32);
		Endpoint ep2out = new Endpoint(2, Endpoint.OUT,Endpoint.BULK, 64, 32);
		Endpoint ep2in =  new Endpoint(2, Endpoint.IN,Endpoint.BULK, 64, 32);
		Endpoint ep3out = new Endpoint(3, Endpoint.OUT,Endpoint.ISOCHRONOUS, 64, 32);
		Endpoint ep3in =  new Endpoint(3, Endpoint.IN,Endpoint.ISOCHRONOUS, 64, 32);
	
		
		//creo interface
		Interface i1 = new Interface(0,0,0,0,0);
		//le asigno los endpoints a la interface i1
		i1.addEndpoint(ep1out);
		i1.addEndpoint(ep1in);
		i1.addEndpoint(ep2out);
		i1.addEndpoint(ep2in);
		i1.addEndpoint(ep3out);
		i1.addEndpoint(ep3in);
		
		//agrego interfaz i1 a la configuracion cfg1
		cfg1.addInterface(i1);
		
		//genero los archivos en la carpeta asignada
		Usb4allConfigGenerator cg = new Usb4allConfigGenerator(dd,"C:/usb4all/fw/Demo/usb4all/usbconf/");
		cg.generateFiles();
		
		System.out.println("Archivos Generados! ;D");
	}
}
