package usb4allConfigGenerator;

import java.util.Vector;

public class Configuration {
	
	private static final String ls = System.getProperty("line.separator");
	
	
	private int configurationStringIndex;
	private int maxPowerConsuption;
	private Vector<Interface> interfaces;
	private DeviceDescriptor myDeviceDescriptor;
	
	
	public Configuration(DeviceDescriptor myDeviceDescriptor, int maxPowerConsuption) {
		super();
		// TODO Auto-generated constructor stub
		this.myDeviceDescriptor = myDeviceDescriptor;
		this.configurationStringIndex = 0;
		this.maxPowerConsuption = maxPowerConsuption ;
		interfaces = new Vector<Interface>();
		//asocio el descriptor con esta configuracion
		myDeviceDescriptor.addConfiguration(this);
	}
	
	public void setConfigurationString(StringDescriptor sd) {
		//chequeo si esta en la coleccion de StringDescriptors
		if (!myDeviceDescriptor.getStringDescriptors().contains(sd)){
			//si no esta lo agrego
			myDeviceDescriptor.addStringDescriptor(sd);
		}
		//seteo el nro de string descritptor de la configuracion
		configurationStringIndex = myDeviceDescriptor.getStringDescriptors().indexOf(sd);
	}

	public void addInterface(Interface i){
		interfaces.addElement(i);
	}
	public int getNumInterfaces(){
		return interfaces.size();
	}
	private String getStartDescriptorC(){
		return "//		 Configuration 1 Descriptor" + ls +
				"CFG01=" + ls +
				"{" + ls +
				"    // Configuration Descriptor" + ls +
				"    sizeof(USB_CFG_DSC),    // Size of this descriptor in bytes" + ls +
				"    DSC_CFG,                // CONFIGURATION descriptor type" + ls +
				"    sizeof(cfg01),          // Total length of data for this cfg" + ls;
				
	}
	
	public String generateDescriptorH(int configurationIndexValue){
		StringBuffer sb = new StringBuffer();
		sb.append("#define "+ getCFGString(configurationIndexValue)+ " rom struct 	\\" + ls +
				"{   USB_CFG_DSC             "+getCD(configurationIndexValue)+";	\\"+ ls);
		//para cada interface entro una linea USB_INTF_DSC y sus endpoints correspondientes 
		for(int i=0;i<interfaces.size();i++){
			sb.append(interfaces.elementAt(i).generateDescriptorH(i));
		}
		sb.append(";	\\"+ls);		
		sb.append("} "+getCFGString(configurationIndexValue).toLowerCase()+ls);		
		
				
		return sb.toString();
	}
	
	private String getCD(int configurationIndexValue){
		int conf = configurationIndexValue+1;
		if (conf<10){
			return "cd0"+conf;
		}
		else return "cd"+conf;
	}
	
	private String getCFGString(int configurationIndexValue){
		int conf = configurationIndexValue+1;
		if (conf<10){
			return "CFG0"+conf;
		}
		else return "CFG"+conf;
	}
	
	
	public String generateDescriptorC(int configurationIndexValue){
		StringBuffer sb = new StringBuffer();
		sb.append(getStartDescriptorC());
		
		sb.append(interfaces.size() +",                      // Number of interfaces in this cfg" + ls +
				(configurationIndexValue+1) +",                      // Index value of this configuration" + ls +
				configurationStringIndex+",                      // Configuration string index" + ls +
						"_DEFAULT,               // Attributes, see usbdefs_std_dsc.h" + ls +
						maxPowerConsuption+",                     // Max power consumption (2X mA)"+ ls);  
		//ahora imprimo las interfaces
		for(int i=0;i<interfaces.size();i++){
			sb.append(interfaces.elementAt(i).generateDescriptorC(i));
		}
		
		
		
		sb.append("};"+ls);
	
		return sb.toString();
	}

	public Vector<Interface> getInterfaces() {
		return interfaces;
	}
	
	/*	
    #define CFG01 rom struct                            \
	{   USB_CFG_DSC             cd01;                   \
	    USB_INTF_DSC            i00a00;                 \
	    USB_EP_DSC              ep01o_i00a00;           \
	    USB_EP_DSC              ep01i_i00a00;           \
		USB_EP_DSC              ep02o_b00a00;           \
	    USB_EP_DSC              ep02i_b00a00;           \
	} cfg01
	*/

	
	/*
	//	 Configuration 1 Descriptor 
	CFG01=
	{
	    // Configuration Descriptor 
	    sizeof(USB_CFG_DSC),    // Size of this descriptor in bytes
	    DSC_CFG,                // CONFIGURATION descriptor type
	    sizeof(cfg01),          // Total length of data for this cfg
	    1,                      // Number of interfaces in this cfg
	    1,                      // Index value of this configuration
	    0,                      // Configuration string index
	    _DEFAULT,               // Attributes, see usbdefs_std_dsc.h
	    50,                     // Max power consumption (2X mA)
	    
	    // Interface Descriptor 
	    sizeof(USB_INTF_DSC),   // Size of this descriptor in bytes
	    DSC_INTF,               // INTERFACE descriptor type
	    0,                      // Interface Number
	    0,                      // Alternate Setting Number
	    4,                      // Number of endpoints in this intf
	    0x00,                   // Class code
	    0x00,                   // Subclass code
	    0x00,                   // Protocol code
	    0,                      // Interface string index
	    
	    // Endpoint Descriptors 
	    sizeof(USB_EP_DSC),DSC_EP,_EP01_OUT,_INT,USBGEN_EP_SIZE,32,
	    sizeof(USB_EP_DSC),DSC_EP,_EP01_IN,_INT,USBGEN_EP_SIZE,32,
		sizeof(USB_EP_DSC),DSC_EP,_EP02_OUT,_BULK,BOOT_EP_SIZE,64,
	    sizeof(USB_EP_DSC),DSC_EP,_EP02_IN,_BULK,BOOT_EP_SIZE,64
	};
	*/

	
}
