package usb4allConfigGenerator;

public class Endpoint {

	private static final String ls = System.getProperty("line.separator");
	public static final int IN = 1;
	public static final int OUT = 0;
	public static final int BULK = 0;
	public static final int INTERRUPT = 1;
	public static final int ISOCHRONOUS = 2;
	public static final int CONTROL = 3;
	
	
	private int endpointNumber;
	private int direction;
	private int endpointType;
	private int endpointSize;
	private int pollingTime;
	
	
	//sizeof(USB_EP_DSC),DSC_EP,_EP01_OUT,_INT,USBGEN_EP_SIZE,32,
    
	public Endpoint(int endpointNumber, int direction, int endpointType, int endpointSize, int pollingTime) {
		super();
		// TODO Auto-generated constructor stub
		this.endpointNumber = endpointNumber;
		this.direction = direction;
		this.endpointType = endpointType;
		this.endpointSize = endpointSize;
		this.pollingTime = pollingTime;
	}

	public String generateDescriptorH(int interfaceNumber){
		//USB_EP_DSC              ep01o_i00a00;
		return "    USB_EP_DSC              "+getEndpointDName(endpointNumber,direction,interfaceNumber);
	}

	private String getEndpointDName(int endpointNumber,int direction,int interfaceNumber){
		StringBuffer sb = new StringBuffer();
		sb.append("ep");
		if (endpointNumber<10){
			sb.append("0");
		}
		sb.append(endpointNumber);
		if (direction==IN){
			sb.append("i");
		}
		else {
			sb.append("o");
		}
		sb.append("_i");
		if (interfaceNumber<10){
			sb.append("0");
		}
		sb.append(interfaceNumber);
		
		sb.append("a00");
		return sb.toString();
	}

	
	public String generateDescriptorC(){
		return "sizeof(USB_EP_DSC),DSC_EP,"+getEndpointName(endpointNumber,direction)+","+getEndpointTypeString(endpointType)+","+endpointSize+","+pollingTime ;
	}
	
	private String getEndpointTypeString(int endpointType){
		switch (endpointType){
		case BULK:
			return "_BULK";
		case INTERRUPT:
			return "_INT";
		case ISOCHRONOUS:
			return "_ISO";
		case CONTROL:
			return "_CONTROL";
		}
		return "";
	}
	
	private String getEndpointName(int endpointNumber,int direction){
		StringBuffer sb = new StringBuffer();
		sb.append("_EP");
		if (endpointNumber<10){
			sb.append("0");
		}
		sb.append(endpointNumber);
		sb.append("_");
		if (direction==IN){
			sb.append("IN");
		}
		else {
			sb.append("OUT");
		}
		return sb.toString();
	}

	public int getDirection() {
		return direction;
	}

	public int getEndpointNumber() {
		return endpointNumber;
	}

	public int getEndpointSize() {
		return endpointSize;
	}

	public int getEndpointType() {
		return endpointType;
	}

	public int getPollingTime() {
		return pollingTime;
	}
	
	
}
