package usb4allConfigGenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Usb4allConfigGenerator {
	
	//configuracion del generador de codigo
	private String destinationDir;
	private static final String descriptorFileName="usbdsc";
	private static final String descriptorDir = "desc/";
	private static final String mmapDir = "usballoc/";
	
	private static final String mmapFileName="usbmmap";
		
	DeviceDescriptor dd;
	
	public Usb4allConfigGenerator(DeviceDescriptor dd,String destinationDir){
		this.dd = dd;
		this.destinationDir=destinationDir;
	}
	
	public void generateFiles(){
		//genero las carpetas
		boolean success=false;
		boolean exists= false;
		exists = (new File(destinationDir+descriptorDir)).exists();
	    if (exists) {
	        // File or directory exists
	    } else {
	    	success = (new File(destinationDir+descriptorDir)).mkdirs();
		    if (!success) {
		        System.out.println("Error al crear la carpeta:"+destinationDir+descriptorDir);
		    }
		    
	    }
		exists = (new File(destinationDir+mmapDir)).exists();
	    if (exists) {
	        // File or directory exists
	    } else {
	    	success = (new File(destinationDir+mmapDir)).mkdirs();
		    if (!success) {
		    	System.out.println("Error al crear la carpeta:"+destinationDir+mmapDir);
		    }

	    }
		
	    
	    
		
		//genero los 4 archivos
		try {
	        BufferedWriter out = new BufferedWriter(new FileWriter(destinationDir+descriptorDir+descriptorFileName+".h"));
	        out.write(dd.generateDescriptorH());
	        out.close();
	    } catch (IOException e) {
	    	e.printStackTrace();
	    }
	    
	    try {
	        BufferedWriter out = new BufferedWriter(new FileWriter(destinationDir+descriptorDir+descriptorFileName+".c"));
	        out.write(dd.generateDescriptorC());
	        out.close();
	    } catch (IOException e) {
	    	e.printStackTrace();
	    }
	    
	    try {
	        BufferedWriter out = new BufferedWriter(new FileWriter(destinationDir+mmapDir+mmapFileName+".h"));
	        out.write(dd.generateMmapH(0));
	        out.close();
	    } catch (IOException e) {
	    	e.printStackTrace();
	    }
	
	    try {
	        BufferedWriter out = new BufferedWriter(new FileWriter(destinationDir+mmapDir+mmapFileName+".c"));
	        out.write(dd.generateMmapC(0));
	        out.close();
	    } catch (IOException e) {
	    	e.printStackTrace();
	    }
	
	
	
	
	}
}
