package test;

import java.util.Arrays;
import java.util.Vector;

import linkscript.LinkScriptParser;
import logica.DataHexRecord;
import logica.rfile;
import mplab.PruebaExec;
import admin.adminModule;
import boot.BootLoaderModule;
import usb4allConfigGenerator.Configuration;
import usb4allConfigGenerator.DeviceDescriptor;
import usb4allConfigGenerator.Endpoint;
import usb4allConfigGenerator.Interface;
import usb4allConfigGenerator.StringDescriptor;
import usb4allConfigGenerator.Usb4allConfigGenerator;

public class TestGenCompBoot {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		TestGenCompBoot gcb = new TestGenCompBoot();
		gcb.usbDescGenerate("C:/usb4all/fw/Demo/usb4all/usbconf/");
		gcb.compileProject("C:/usb4all/fw/Demo/USB4all.mcp");
		gcb.sendBootLoader("C:/usb4all/fw/Demo/USB4all.hex");
	}
	
	//	folder donde se van a generar los archivos de descriptores usb
	public void usbDescGenerate(String confFolder){
		 
		//TODO falta pingpong buffer, varias cfg, varias interfaces, y ep control e iso
		DeviceDescriptor dd = new DeviceDescriptor(2,0,0,0,8,0x04D8,0x000C,0);
		
		//genero string descriptors
		StringDescriptor sd0 = new StringDescriptor(0x0409);
		StringDescriptor sd1 = new StringDescriptor("Aguirre Fernandez Grossy");
		StringDescriptor sd2 = new StringDescriptor("USB4all (C)2007");
		StringDescriptor sd3 = new StringDescriptor("11111111");		
	
		//los asigno al device descriptor
		dd.addStringDescriptor(sd0);
		dd.addStringDescriptor(sd1);
		dd.addStringDescriptor(sd2);
		dd.addStringDescriptor(sd3);
		
		//asigno strings de manofacturer y product
		dd.setManufacturerString(sd1);
		dd.setProductString(sd2);
		dd.setDeviceSerialNumberString(sd3);
		//creo configuracion 1
		Configuration cfg1 = new Configuration(dd,50);
		
		//creo endpoints
		Endpoint ep1out = new Endpoint(1, Endpoint.OUT,Endpoint.BULK, 64, 32);
		Endpoint ep1in =  new Endpoint(1, Endpoint.IN,Endpoint.BULK, 64, 32);
		Endpoint ep2out = new Endpoint(2, Endpoint.OUT,Endpoint.BULK, 64, 32);
		Endpoint ep2in =  new Endpoint(2, Endpoint.IN,Endpoint.BULK, 64, 32);
		Endpoint ep3out = new Endpoint(3, Endpoint.OUT,Endpoint.ISOCHRONOUS, 64, 250);
		Endpoint ep3in =  new Endpoint(3, Endpoint.IN,Endpoint.ISOCHRONOUS, 64, 250);
	
		
		//creo interface
		Interface i1 = new Interface(0,0,0,0,0);
		//le asigno los endpoints a la interface i1
		i1.addEndpoint(ep1out);
		i1.addEndpoint(ep1in);
		i1.addEndpoint(ep2out);
		i1.addEndpoint(ep2in);
		i1.addEndpoint(ep3out);
		i1.addEndpoint(ep3in);
		
		//agrego interfaz i1 a la configuracion cfg1
		cfg1.addInterface(i1);
		
		//genero los archivos en la carpeta asignada
		Usb4allConfigGenerator cg = new Usb4allConfigGenerator(dd,confFolder);
		cg.generateFiles();
		
		System.out.println("Archivos Generados! ;D");
	}
	
	public void compileProject(String mcpFilename){
		PruebaExec pe = new PruebaExec();
		pe.compileProject(mcpFilename);
	}
	
	public void sendBootLoader(String hexFilename){
		
		//cargo el hexfile del cual se van a extraer los descriptores.
		rfile rf= new rfile();
		rf.readHexFile(hexFilename);
		
		//cargo y parseo el archivo linkscript que me dice las posiciones de 
		//los descriptores en el hexfile
		LinkScriptParser lsp = new LinkScriptParser();
		lsp.parseFromFile("C:/usb4all/fw/Demo/rm18f4550.lkr");
		
				
		adminModule am = new adminModule();
		am.init(0,0);
		am.open();
		am.openModule("boot\0",2,2);
		am.close(); //cierro el endpoint para que lo pueda abrir el bootloadermodule
		
		
		BootLoaderModule blm = new BootLoaderModule();
		blm.init(0,1,2,2);
		System.out.println("luego del open");
		blm.open();
		//byte tempv[] = blm.getVersion();
		//System.out.println("la version del modulo de boot es :" + tempv);
		//blm.reset();
		//comandos para el bootloader
		
		//grabo secciones
		//grabarSeccion(rf,lsp,LinkScriptParser.USB_ENDPOINTS_INIT,blm);
		//grabarSeccion(rf,lsp,LinkScriptParser.DEVICE_DSC,blm);
		grabarSeccion(rf,lsp,LinkScriptParser.USB_CD_PTR,blm);
		grabarSeccion(rf,lsp,LinkScriptParser.USB_SD_PTR,blm);
		
		blm.close();  //cierro el endpoint para que lo pueda abrir el admin para hacer loseModule
		
		//realizo el close del modulo con handler 1
		am.open();
		am.closeModule(1);
		am.close();
		
		
		}

	public void grabarSeccion(rfile rf,LinkScriptParser lsp,String section,BootLoaderModule blm){
//		obtengo direccion de inicio y fin de una seccion
		int startAddress = lsp.getStartAddress(section);
		int endAddress = lsp.getEndAddress(section);
		//System.out.println("El start de la seccion USB_ENDPOINTS_INIT es: " + startAddress);
		//System.out.println("El end de la seccion USB_ENDPOINTS_INIT es: " + endAddress);
		
		//obtengo los records del hex file entre posiciones de inicio  y fin
		Vector<DataHexRecord> dhr = rf.getRecords(startAddress,endAddress);
		/*
		for (int i=0; i<dhr.size(); i++){
			System.out.println(" linear addr : " + dhr.elementAt(i).getLinearAddress() );
			rf.printDataArray(dhr.elementAt(i).getData());
		}
		*/
		
		
		boolean resultado=true;
		Vector<DataHexRecord> lhr = dhr;
		for (int i=0 ; i<lhr.size() ; i++){
			DataHexRecord hrr = lhr.elementAt(i);
			byte[] readBytes =  blm.readFlash(hrr.getLinearAddress(),hrr.getData().length);
				if (Arrays.equals(hrr.getData(),readBytes)){
					System.out.println("coinciden");
				}
				else {
					System.out.println("NO coinciden");
					resultado=false;
				}
			}
		int offset = 0;
		//System.out.println("El offset es: "+ offset);
		//System.out.println("BORRO TODO");
		if (resultado) {
			System.out.println("NO es necesario grabar la seccion");
		}
		else {
			System.out.println("ES necesario grabar la seccion");
		}
		//resultado = false; //sacarselo cuando ande
		if (!resultado){
			System.out.println("el size de la seccion es: " + (endAddress - startAddress) + "cant erases=" + ((endAddress - startAddress + 1)/64) );
			System.out.println("Hago erase en:" + (startAddress+offset));
			int cantErases = ((endAddress - startAddress + 1)/64); 
			for (int e=0 ; e<cantErases ; e++ ) {
				blm.eraseFlash(startAddress+offset + 64*e);
			}
			System.out.println("TERMINO EL ERASE");
			resultado=true;
			for (int i=0 ; i<lhr.size() ; i++){
				DataHexRecord hrr = lhr.elementAt(i);
				//escribo en la flash todo 
				blm.writeFlash(hrr.getLinearAddress()+offset,hrr.getData());
				System.out.println("Escribo en:" + Integer.toHexString((hrr.getLinearAddress()+offset)));
				
				byte[] readBytes =  blm.readFlash(hrr.getLinearAddress()+offset,hrr.getData().length);
				if (Arrays.equals(hrr.getData(),readBytes)){
					System.out.println("Quedo bien grabado");
				}
				else {
					System.out.println("error al GRABAR EL NUEVO USB_DESCRIPTOR");
					resultado=false;
				}
				
			}
		}
	}
	
}
