/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.GlobalMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseColor
extends AbstractBasicData<ChooseColor> {
    LONG lStructSize;
    HWND hwndOwner;
    HWND hInstance;
    public LONG rgbResult;
    static Pointer lpCustColors;
    LONG Flags;
    LPARAM lCustData;
    int lpfnHook;
    Callback fnHook;
    Pointer lpTemplateName;

    static {
        try {
            lpCustColors = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public ChooseColor() throws NativeException {
        super(null);
        this.mValue = this;
        this.createPointer();
    }

    public void removeCallback() throws NativeException {
        if (this.fnHook != null) {
            JNative.releaseCallback(this.fnHook);
            this.fnHook = null;
        }
    }

    public void addCallback(Callback lCallback) throws NativeException {
        this.removeCallback();
        this.fnHook = lCallback;
        this.lpfnHook = JNative.createCallback(4, lCallback);
        this.pointer.setIntAt(28, this.lpfnHook);
    }

    @Override
    public ChooseColor getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.lStructSize = new LONG(this.getNextInt());
        this.hwndOwner = new HWND(this.getNextInt());
        this.hInstance = new HWND(this.getNextInt());
        this.rgbResult = new LONG(this.getNextInt());
        this.offset += 4;
        this.Flags = new LONG(this.getNextInt());
        this.lCustData = new LPARAM(this.getNextInt());
        return (ChooseColor)this.getValue();
    }

    @Override
    public int getSizeOf() {
        return 36;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(new GlobalMemoryBlock(this.getSizeOf()));
        this.pointer.setIntAt(0, this.getSizeOf());
        this.pointer.setIntAt(16, lpCustColors.getPointer());
        return this.pointer;
    }

    public void setOwner(HWND owner) throws NativeException {
        this.hwndOwner = owner;
        this.pointer.setIntAt(4, (Integer)this.hwndOwner.getValue());
    }

    public void setInstance(HWND instance) throws NativeException {
        this.hInstance = instance;
        this.pointer.setIntAt(8, (Integer)this.hInstance.getValue());
    }

    public void setFlags(LONG flags) throws NativeException {
        this.Flags = flags;
        this.pointer.setIntAt(20, this.Flags.getValue());
    }

    public void setCustData(LPARAM custData) throws NativeException {
        this.lCustData = custData;
        this.pointer.setIntAt(24, this.lCustData.getValue());
    }

    public void setTemplateName(String templateName) throws NativeException {
        if (templateName == null) {
            this.lpTemplateName = new NullPointer();
        } else {
            this.lpTemplateName = new Pointer(MemoryBlockFactory.createMemoryBlock(templateName.length() + 1));
            this.lpTemplateName.setMemory(templateName);
        }
        this.pointer.setIntAt(32, this.lpTemplateName.getPointer());
    }
}

