/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.pointers;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.memory.MemoryBlock;
import org.xvolks.jnative.util.StructConverter;

public class Pointer {
    private MemoryBlock mem;

    public Pointer(MemoryBlock mem) {
        this.mem = mem;
    }

    public void dispose() throws NativeException {
        this.mem.dispose();
    }

    public int getPointer() {
        return this.mem.getPointer();
    }

    public int getSize() {
        return this.mem.getSize();
    }

    public void setMemory(String buffer) throws NativeException, ArrayIndexOutOfBoundsException {
        if (buffer.length() > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This string is bigger than the current memory addressed by my pointer : " + buffer.length() + ">" + this.mem.getSize());
        }
        JNative.setMemory((int)this.mem.getPointer(), buffer);
    }

    public void setMemory(byte[] buffer) throws NativeException {
        if (buffer.length > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This buffer is bigger than the current memory addressed by my pointer : " + buffer.length + ">" + this.mem.getSize());
        }
        JNative.setMemory((int)this.mem.getPointer(), buffer);
    }

    public int setByteAt(int offset, byte value) throws NativeException {
        if (offset > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + offset + ">" + this.mem.getSize());
        }
        byte[] buf = new byte[]{value};
        JNative.setMemory(this.mem.getPointer(), buf, offset, 1);
        return 1;
    }

    public int setShortAt(int offset, short value) throws NativeException {
        if (offset + 2 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (offset + 2) + ">" + this.mem.getSize());
        }
        byte[] buf = new byte[2];
        StructConverter.shortIntoBytes(value, buf, 0);
        JNative.setMemory(this.mem.getPointer(), buf, offset, 2);
        return 2;
    }

    public int setIntAt(int offset, int value) throws NativeException {
        if (offset + 4 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (offset + 4) + ">" + this.mem.getSize());
        }
        byte[] buf = new byte[4];
        StructConverter.intIntoBytes(value, buf, 0);
        JNative.setMemory(this.mem.getPointer(), buf, offset, 4);
        return 4;
    }

    public int setLongAt(int offset, long value) throws NativeException {
        if (offset + 8 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (offset + 8) + ">" + this.mem.getSize());
        }
        byte[] buf = new byte[8];
        StructConverter.longIntoBytes(value, buf, 0);
        JNative.setMemory(this.mem.getPointer(), buf, offset, 8);
        return 8;
    }

    public int setFloatAt(int offset, float value) throws NativeException {
        if (offset + 4 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (offset + 8) + ">" + this.mem.getSize());
        }
        byte[] buf = new byte[8];
        StructConverter.floatIntoBytes(value, buf, 0);
        JNative.setMemory(this.mem.getPointer(), buf, offset, 8);
        return 8;
    }

    public int setDoubleAt(int offset, double value) throws NativeException {
        if (offset + 8 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (offset + 8) + ">" + this.mem.getSize());
        }
        byte[] buf = new byte[8];
        StructConverter.doubleIntoBytes(value, buf, 0);
        JNative.setMemory(this.mem.getPointer(), buf, offset, 8);
        return 8;
    }

    public int setStringAt(int offset, String value) throws NativeException {
        int len = value.length();
        if (offset + len >= this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (offset + len) + ">" + this.mem.getSize());
        }
        JNative.setMemory(this.mem.getPointer(), value.getBytes(), offset, len);
        return len;
    }

    public void zeroMemory() throws NativeException {
        this.setMemory(new byte[this.mem.getSize()]);
    }

    public byte[] getMemory() throws NativeException {
        return JNative.getMemory(this.mem.getPointer(), this.mem.getSize());
    }

    public String getAsString() throws NativeException {
        return JNative.getMemoryAsString(this.mem.getPointer(), this.mem.getSize());
    }

    public byte getAsByte(int offset) throws NativeException {
        return JNative.getMemory(this.mem.getPointer(), this.mem.getSize())[offset];
    }

    public short getAsShort(int offset) throws NativeException {
        return StructConverter.bytesIntoShort(JNative.getMemory(this.mem.getPointer(), this.mem.getSize()), offset);
    }

    public int getAsInt(int offset) throws NativeException {
        return StructConverter.bytesIntoInt(JNative.getMemory(this.mem.getPointer(), this.mem.getSize()), offset);
    }

    public long getAsLong(int offset) throws NativeException {
        return StructConverter.bytesIntoLong(JNative.getMemory(this.mem.getPointer(), this.mem.getSize()), offset);
    }

    public float getAsFloat(int offset) throws NativeException {
        return StructConverter.bytesIntoFloat(JNative.getMemory(this.mem.getPointer(), this.mem.getSize()), offset);
    }

    public double getAsDouble(int offset) throws NativeException {
        return StructConverter.bytesIntoDouble(JNative.getMemory(this.mem.getPointer(), this.mem.getSize()), offset);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isNull() {
        return this.mem == null || this.mem.getPointer() == 0;
    }

    public LONG asLONG() {
        return new LONG(this.getPointer());
    }
}

