/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import org.xvolks.jnative.Convention;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.ConsoleLogger;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.DbgHelp;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.StructConverter;
import org.xvolks.jnative.util.WindowProc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNative {
    private static final Map<String, LibDesc> mLibs;
    private final int mJNativePointer;
    private int mJNativeHModule;
    private int convention;
    private boolean isClosed = false;
    private final String mDllName;
    private final String mFunctionName;
    private static Map<Integer, Callback> callbacks;
    private Vector<byte[]> parameters = new Vector();
    private Vector<Integer> parameterTypes = new Vector();
    private String mRetValue;
    private int mRetType;
    private static final boolean isWindows;
    private static final boolean isLinux;
    private static JNativeLogger logger;
    private static boolean initDone;
    private static boolean DEBUG;

    static {
        block14: {
            boolean lInit;
            block13: {
                callbacks = new TreeMap<Integer, Callback>();
                logger = null;
                lInit = false;
                String debug = System.getProperty("jnative.debug");
                if (debug != null) {
                    try {
                        JNative.setLoggingEnabled(Boolean.parseBoolean(debug));
                    }
                    catch (Exception e) {
                        System.err.println("DEBUG messages disabled!");
                        e.printStackTrace();
                        JNative.setLoggingEnabled(false);
                    }
                } else {
                    JNative.setLoggingEnabled(false);
                }
                mLibs = Boolean.parseBoolean(System.getProperty("jnative.weakRef")) ? new WeakHashMap() : new HashMap();
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Using a " + mLibs.getClass().getName() + " as native handles storage");
                try {
                    try {
                        String loadNative = System.getProperty("jnative.loadNative");
                        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "jnative.loadNative property = " + loadNative);
                        if (loadNative == null || loadNative.equalsIgnoreCase("default")) {
                            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Using default System.loadLibrary()");
                            System.loadLibrary("JNativeCpp");
                            lInit = true;
                        } else if (loadNative.equalsIgnoreCase("manual")) {
                            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Using manual : you MUST load the library yourself, then init callbacks !");
                            lInit = true;
                        } else {
                            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Trying to load Library from " + loadNative);
                            System.load(loadNative);
                            lInit = true;
                        }
                    }
                    catch (Throwable e) {
                        JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    initDone = lInit;
                    String osName = System.getProperty("os.name");
                    isWindows = osName.toLowerCase().indexOf("windows") != -1;
                    isLinux = osName.toLowerCase().indexOf("linux") != -1;
                    throw throwable;
                }
                initDone = lInit;
                String string = System.getProperty("os.name");
                isWindows = string.toLowerCase().indexOf("windows") != -1;
                isLinux = string.toLowerCase().indexOf("linux") != -1;
                break block14;
            }
            initDone = lInit;
            String string = System.getProperty("os.name");
            isWindows = string.toLowerCase().indexOf("windows") != -1;
            isLinux = string.toLowerCase().indexOf("linux") != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LibDesc getLibDesc(String name) {
        Map<String, LibDesc> map = mLibs;
        synchronized (map) {
            LibDesc libDesc = mLibs.get(name);
            if (libDesc == null) {
                libDesc = new LibDesc();
                libDesc.libName = name;
                mLibs.put(name, libDesc);
            }
            return libDesc;
        }
    }

    private Vector<byte[]> getParameters() {
        return this.parameters;
    }

    private Vector<Integer> getParameterTypes() {
        return this.parameterTypes;
    }

    public static int callback(int address, long[] values) {
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("in Java callback #%x with %d arguments\n", address, values.length));
        return callbacks.get(address).callback(values);
    }

    public String toString() {
        return String.valueOf(this.mDllName) + "-" + this.mFunctionName;
    }

    private native int nLoadLibrary(String var1, String var2, boolean var3) throws NativeException;

    private native int nFindFunction(int var1, String var2, boolean var3) throws NativeException;

    private native String nGetParameter(int var1, int var2) throws NativeException;

    private native void nInvoke(int var1) throws NativeException;

    private native void nDispose(int var1) throws NativeException;

    private static native int nMalloc(int var0) throws NativeException;

    private static native void nFree(int var0) throws NativeException;

    private static native void nSetMemory(int var0, byte[] var1, int var2, int var3) throws NativeException;

    private static native byte[] nGetMemory(int var0, int var1) throws NativeException;

    private static native int nRegisterWindowProc(int var0, Object var1, boolean var2) throws NativeException;

    private static native int nGetCurrentModule() throws NativeException;

    private static native int nCreateCallBack(int var0) throws NativeException;

    private static native boolean nReleaseCallBack(int var0) throws NativeException;

    private static native int nGetNativePattern(int var0, byte[] var1, int var2) throws NativeException;

    private static native String nGetNativeSideVersion() throws NativeException;

    public static void setDefaultCallingConvention(Convention defaultConvention) {
        Convention.setDefaultStyle(defaultConvention);
    }

    public JNative(int address, Convention convention) throws NativeException {
        if (!initDone) {
            throw new IllegalStateException("JNative library not loaded, sorry !");
        }
        this.convention = convention.getValue();
        this.mFunctionName = this.mDllName = "Anonymous";
        this.mJNativePointer = address;
        try {
            this.setRetVal(Type.VOID);
        }
        catch (IllegalAccessException e) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
        }
    }

    public JNative(String dllName, String functionName) throws NativeException {
        this(dllName, functionName, false, Convention.DEFAULT);
    }

    public JNative(String dllName, String functionName, Convention convention) throws NativeException {
        this(dllName, functionName, false, convention);
    }

    public JNative(String dllName, String functionName, boolean debug) throws NativeException {
        this(dllName, functionName, debug, Convention.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JNative(String dllName, String functionName, boolean nativeDebug, Convention convention) throws NativeException {
        if (!initDone) {
            throw new IllegalStateException("JNative library not loaded, sorry !");
        }
        this.convention = convention.getValue();
        this.mDllName = dllName;
        Map<String, LibDesc> map = mLibs;
        synchronized (map) {
            LibDesc libDesc = JNative.getLibDesc(this.mDllName);
            this.mFunctionName = functionName;
            ++libDesc.numHolders;
            if (libDesc.handle == 0) {
                this.mJNativePointer = this.nLoadLibrary(dllName, functionName, nativeDebug);
                libDesc.handle = this.mJNativeHModule;
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Creating " + libDesc);
            } else {
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Resusing " + libDesc);
                this.mJNativeHModule = libDesc.handle;
                this.mJNativePointer = this.nFindFunction(this.mJNativeHModule, functionName, nativeDebug);
            }
        }
        try {
            this.setRetVal(Type.VOID);
        }
        catch (IllegalAccessException e) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
        }
    }

    public int getFunctionPointer() throws IllegalAccessException {
        this.throwClosed();
        return this.mJNativePointer;
    }

    public void setParameter(int pos, int value) throws IllegalAccessException {
        this.setParameter(pos, Type.INT, String.valueOf(value));
    }

    public void setParameter(int pos, Type type, String value) throws IllegalAccessException {
        if (value == null) {
            this.setParameter(pos, 0);
        } else {
            this.setParameter(pos, type, (String.valueOf(value) + '\u0000').getBytes());
        }
    }

    public void setParameter(int pos, String lValue) throws IllegalAccessException {
        this.setParameter(pos, Type.STRING, lValue);
    }

    public void setParameter(int pos, Type type, byte[] value) throws IllegalAccessException {
        this.throwClosed();
        if (this.parameters.size() <= pos) {
            int i = this.parameters.size();
            while (i++ <= pos) {
                this.parameters.add(new byte[4]);
                this.parameterTypes.add(Type.INT.getNativeType());
            }
        }
        this.parameters.set(pos, value);
        this.parameterTypes.set(pos, type.getNativeType());
    }

    public void setParameter(int pos, Pointer p) throws NativeException, IllegalAccessException {
        this.throwClosed();
        if (p == null || p.getPointer() == 0) {
            this.setParameter(pos, 0);
        } else {
            byte[] buf = new byte[4];
            StructConverter.intIntoBytes(p.getPointer(), buf, 0);
            this.setParameter(pos, Type.PSTRUCT, buf);
        }
    }

    public void setRetVal(Type type) throws NativeException, IllegalAccessException {
        this.throwClosed();
        this.mRetType = type.getNativeType();
    }

    public String getRetVal() throws IllegalAccessException {
        this.throwClosed();
        return this.mRetValue;
    }

    public int getRetValAsInt() throws IllegalAccessException {
        this.throwClosed();
        return Integer.parseInt(this.mRetValue);
    }

    public String getParameter(int pos) throws NativeException, IllegalAccessException {
        this.throwClosed();
        return this.nGetParameter(this.mJNativePointer, pos);
    }

    public void invoke() throws NativeException, IllegalAccessException {
        this.throwClosed();
        this.nInvoke(this.mJNativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() throws NativeException, IllegalAccessException {
        this.throwClosed();
        Map<String, LibDesc> map = mLibs;
        synchronized (map) {
            LibDesc libDesc = JNative.getLibDesc(this.mDllName);
            --libDesc.numHolders;
            if (libDesc.numHolders == 0) {
                this.nDispose(this.mJNativeHModule);
                this.isClosed = true;
                mLibs.remove(this.mDllName);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final String getFunctionName() {
        return this.mFunctionName;
    }

    public final String getDLLName() {
        return this.mDllName;
    }

    public Convention getStyle() {
        return Convention.fromInt(this.convention);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JNative)) {
            return false;
        }
        JNative n = (JNative)obj;
        return this.mDllName.equals(n.getDLLName()) && this.mFunctionName.equals(n.getFunctionName());
    }

    private void throwClosed() throws IllegalAccessException {
        if (this.isClosed) {
            throw new IllegalAccessException("This function (" + this.getFunctionName() + " in " + this.getDLLName() + ") is already closed");
        }
    }

    public static int allocMemory(int size) throws NativeException {
        return JNative.nMalloc(size);
    }

    public static void freeMemory(int pointer) throws NativeException {
        JNative.nFree(pointer);
    }

    public static void setMemory(int pointer, String buffer) throws NativeException {
        JNative.setMemory(pointer, buffer.getBytes());
    }

    public static void setMemory(int pointer, byte[] buffer) throws NativeException {
        JNative.setMemory(pointer, buffer, 0, buffer.length);
    }

    public static void setMemory(int pointer, byte[] buffer, int offset, int len) throws NativeException {
        JNative.nSetMemory(pointer, buffer, offset, len);
    }

    public static byte[] getMemory(int pointer, int size) throws NativeException {
        return JNative.nGetMemory(pointer, size);
    }

    public static String getMemoryAsString(int pointer, int size) throws NativeException {
        byte[] buf = JNative.nGetMemory(pointer, size);
        int i = 0;
        while (i < buf.length) {
            if (buf[i] == 0) {
                return new String(buf, 0, i);
            }
            ++i;
        }
        return new String(buf);
    }

    public static int registerWindowProc(int hwnd, WindowProc proc) throws NativeException {
        return JNative.nRegisterWindowProc(hwnd, proc, false);
    }

    public static int registerWindowProc(HWND hwnd, WindowProc proc) throws NativeException {
        return JNative.nRegisterWindowProc((Integer)hwnd.getValue(), proc, false);
    }

    public static int createCallback(int numParams, Callback callback) throws NativeException {
        Integer address = JNative.nCreateCallBack(numParams);
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("registering callback %x\n", address));
        callbacks.put(address, callback);
        return address;
    }

    public static boolean releaseCallback(Callback callback) throws NativeException {
        if (callbacks.remove(callback.getCallbackAddress()) != null) {
            return JNative.nReleaseCallBack(callback.getCallbackAddress());
        }
        return false;
    }

    public static int getAvailableCallbacks() {
        return 1000;
    }

    public static int getCurrentModule() throws NativeException {
        return JNative.nGetCurrentModule();
    }

    public static String[] getDLLFileExports(String dllFile, boolean demangled) throws NativeException, InterruptedException {
        if (isWindows) {
            LONG ppdwNames;
            Pointer pImg_Export_Dir;
            Pointer pImg_NT_Header;
            Pointer pImg_DOS_Header;
            LONG lpFileBase;
            HANDLE hFileMapping;
            HANDLE hFile;
            block21: {
                int IMAGE_EXPORT_DIRECTORY_SIZE;
                block20: {
                    int IMAGE_NT_HEADERS32_SIZE;
                    int IMAGE_OPTIONAL_HEADER32_SIZE;
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    hFile = Kernel32.CreateFile(dllFile, Kernel32.AccessMask.GENERIC_READ, Kernel32.ShareMode.FILE_SHARE_READ, null, Kernel32.CreationDisposition.OPEN_EXISTING, Kernel32.FileAttribute.FILE_ATTRIBUTE_NORMAL, 0);
                                    if (!hFile.equals(HANDLE.INVALID_HANDLE_VALUE)) break block16;
                                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : %s file not found, CreateFile returned an invalid handle\n", dllFile));
                                    return null;
                                }
                                hFileMapping = Kernel32.CreateFileMapping(hFile, null, Kernel32.PageAccess.PAGE_READONLY, new DWORD(0), new DWORD(0), null);
                                if (!hFileMapping.equals(HANDLE.INVALID_HANDLE_VALUE)) break block17;
                                Kernel32.CloseHandle(hFile);
                                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : CreateFileMapping returned a NULL handle\n", new Object[0]));
                                return null;
                            }
                            lpFileBase = Kernel32.MapViewOfFileEx(hFileMapping, Kernel32.FileMap.FILE_MAP_READ, new DWORD(0), new DWORD(0), new DWORD(0), new LONG(0));
                            if (lpFileBase.getValue() != 0) break block18;
                            Kernel32.CloseHandle(hFileMapping);
                            Kernel32.CloseHandle(hFile);
                            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : MapViewOfFile returned 0\n", new Object[0]));
                            return null;
                        }
                        int IMAGE_DOS_HEADER_SIZE = 64;
                        int IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16;
                        IMAGE_OPTIONAL_HEADER32_SIZE = 96 + IMAGE_NUMBEROF_DIRECTORY_ENTRIES * 2 * 4;
                        IMAGE_NT_HEADERS32_SIZE = 24 + IMAGE_OPTIONAL_HEADER32_SIZE;
                        int IMAGE_NT_SIGNATURE = 17744;
                        IMAGE_EXPORT_DIRECTORY_SIZE = 40;
                        pImg_DOS_Header = new Pointer(new NativeMemoryBlock(lpFileBase.getValue(), IMAGE_DOS_HEADER_SIZE));
                        pImg_NT_Header = new Pointer(new NativeMemoryBlock(pImg_DOS_Header.getPointer() + pImg_DOS_Header.getAsInt(IMAGE_DOS_HEADER_SIZE - 4), IMAGE_NT_HEADERS32_SIZE));
                        if (Kernel32.IsBadReadPtr(pImg_NT_Header) && pImg_NT_Header.getAsInt(0) == IMAGE_NT_SIGNATURE) break block19;
                        Kernel32.UnmapViewOfFile(lpFileBase);
                        Kernel32.CloseHandle(hFileMapping);
                        Kernel32.CloseHandle(hFile);
                        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : IsBadReadPtr returned false, pointer is %d\n", pImg_NT_Header.getPointer()));
                        return null;
                    }
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>INFO<<< : IsBadReadPtr returned true, pointer is %d\n", pImg_NT_Header.getPointer()));
                    Pointer pOptionalHeader = new Pointer(new NativeMemoryBlock(pImg_NT_Header.getPointer() + IMAGE_NT_HEADERS32_SIZE - IMAGE_OPTIONAL_HEADER32_SIZE, IMAGE_OPTIONAL_HEADER32_SIZE));
                    pImg_Export_Dir = new Pointer(new NativeMemoryBlock(pOptionalHeader.getAsInt(96), 4));
                    if (!pImg_Export_Dir.isNull()) break block20;
                    Kernel32.UnmapViewOfFile(lpFileBase);
                    Kernel32.CloseHandle(hFileMapping);
                    Kernel32.CloseHandle(hFile);
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : pImg_Export_Dir is NULL\n", new Object[0]));
                    return null;
                }
                pImg_Export_Dir = new Pointer(new NativeMemoryBlock(DbgHelp.ImageRvaToVa(pImg_NT_Header, pImg_DOS_Header, pImg_Export_Dir.asLONG(), NullPointer.NULL).getValue(), IMAGE_EXPORT_DIRECTORY_SIZE));
                ppdwNames = new LONG(pImg_Export_Dir.getAsInt(32));
                ppdwNames = DbgHelp.ImageRvaToVa(pImg_NT_Header, pImg_DOS_Header, ppdwNames, NullPointer.NULL);
                if (ppdwNames.getValue() != 0) break block21;
                Kernel32.UnmapViewOfFile(lpFileBase);
                Kernel32.CloseHandle(hFileMapping);
                Kernel32.CloseHandle(hFile);
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : ImageRvaToVa returned NULL\n", new Object[0]));
                return null;
            }
            try {
                int iNoOfExports = pImg_Export_Dir.getAsInt(24);
                String[] pszFunctions = new String[iNoOfExports];
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("pszFunctions = %d\n", pszFunctions.length));
                int i = 0;
                int ippdwNames = ppdwNames.getValue();
                while (i < iNoOfExports) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("ippdwNames[%d] : %d\n", i, ippdwNames));
                    LONG szFunc = DbgHelp.ImageRvaToVa(pImg_NT_Header, pImg_DOS_Header, new LONG(new Pointer(new NativeMemoryBlock(ippdwNames, 4)).getAsInt(0)), NullPointer.NULL);
                    pszFunctions[i] = new Pointer(new NativeMemoryBlock(szFunc.getValue(), 1000)).getAsString();
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, pszFunctions[i]);
                    ++i;
                    ippdwNames += 4;
                }
                Kernel32.UnmapViewOfFile(lpFileBase);
                Kernel32.CloseHandle(hFileMapping);
                Kernel32.CloseHandle(hFile);
                return pszFunctions;
            }
            catch (IllegalAccessException e) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
                return null;
            }
        }
        if (isLinux) {
            try {
                String option = "";
                if (demangled) {
                    option = "C";
                }
                Process p = Runtime.getRuntime().exec("/usr/bin/nm -" + option + "Dg --defined-only " + dllFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = br.readLine();
                ArrayList<String> l = new ArrayList<String>();
                while (line != null) {
                    l.add(line);
                    line = br.readLine();
                }
                br.close();
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "exit value : " + p.waitFor());
                String[] array = new String[l.size()];
                int i = 0;
                for (String s : l) {
                    array[i++] = s;
                }
                return array;
            }
            catch (IOException e) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
                throw new NativeException(e.getMessage());
            }
        }
        return null;
    }

    public static String[] getDLLFileExports(String dllFile) throws NativeException, InterruptedException {
        return JNative.getDLLFileExports(dllFile, false);
    }

    public static int searchNativePattern(int nativePointer, byte[] pattern, int maxSize) throws NativeException {
        return JNative.nGetNativePattern(nativePointer, pattern, maxSize);
    }

    public static int searchNativePattern(Pointer pointer, byte[] pattern, int maxSize) throws NativeException {
        return JNative.nGetNativePattern(pointer.getPointer(), pattern, maxSize);
    }

    public static String getNativeSideVersion() throws NativeException {
        return JNative.nGetNativeSideVersion();
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void setLogger(JNativeLogger _logger) {
        logger = _logger;
    }

    public static JNativeLogger getLogger() {
        if (logger == null) {
            logger = ConsoleLogger.getInstance(JNative.class);
        }
        return logger;
    }

    public static void setLoggingEnabled(boolean b) {
        DEBUG = b;
    }

    public static boolean isLogginEnabled() {
        return DEBUG;
    }

    public static void initCallbacks() throws NativeException {
    }

    public static class LibDesc {
        int handle;
        String libName;
        int numHolders;

        public String toString() {
            return String.format("Lib info (name = %s, handle = %x, inUseFor = %d)", this.libName, this.handle, this.numHolders);
        }
    }
}

