/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.logging;

import java.text.SimpleDateFormat;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.logging.AbstractLogger;
import org.xvolks.jnative.logging.JNativeLogger;

public class ConsoleLogger
extends AbstractLogger {
    private ConsoleLogger() {
    }

    public static JNativeLogger getInstance(Class clazz) {
        return ConsoleLogger.getInstance(clazz.getName());
    }

    public static JNativeLogger getInstance(String name) {
        JNativeLogger logger = null;
        if (!loggers.containsKey(name)) {
            logger = new ConsoleLogger();
            logger.setName(name);
            loggers.put(name, logger);
        } else {
            logger = (JNativeLogger)loggers.get(name);
        }
        return logger;
    }

    public void log(JNativeLogger.SEVERITY severity, Object message) {
        String[] str;
        if (!JNative.isLogginEnabled()) {
            return;
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(SimpleDateFormat.getDateTimeInstance().format(System.currentTimeMillis()));
        strBuf.append(",");
        if (severity != null) {
            strBuf.append(" " + severity.getName());
        }
        if ((str = this.inferCaller()) != null) {
            strBuf.append(" [" + str[0] + "]");
            strBuf.append(" [" + str[1] + "]: ");
        }
        if (message instanceof Throwable) {
            Throwable err = (Throwable)message;
            strBuf.append(err.getMessage());
            int i = 0;
            while (i < err.getStackTrace().length) {
                strBuf.append(System.getProperty("line.separator"));
                strBuf.append(err.getStackTrace()[i].toString());
                ++i;
            }
        } else {
            strBuf.append(message);
        }
        System.err.println(strBuf.toString());
    }

    private String[] inferCaller() {
        String cname;
        StackTraceElement frame;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int ix = 0;
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (cname.equals("xvolks.jnative.logging.ConsoleLogger")) break;
            ++ix;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals("xvolks.jnative.logging.ConsoleLogger")) {
                String[] str = new String[]{cname, frame.getMethodName()};
                return str;
            }
            ++ix;
        }
        return null;
    }

    public void log(Object message) {
        this.log(JNativeLogger.SEVERITY.INFO, message);
    }
}

