/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc.basicStructures;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.BasicData;
import org.xvolks.jnative.pointers.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicData<T>
implements BasicData<T> {
    protected T mValue;
    protected Pointer pointer;
    protected int offset;

    protected byte getNextByte() throws NativeException {
        return this.pointer.getAsByte(this.offset++);
    }

    protected short getNextShort() throws NativeException {
        try {
            short s = this.pointer.getAsShort(this.offset);
            return s;
        }
        finally {
            this.offset += 2;
        }
    }

    protected int getNextInt() throws NativeException {
        try {
            int n = this.pointer.getAsInt(this.offset);
            return n;
        }
        finally {
            this.offset += 4;
        }
    }

    protected long getNextLong() throws NativeException {
        try {
            long l = this.pointer.getAsLong(this.offset);
            return l;
        }
        finally {
            this.offset += 8;
        }
    }

    @Override
    public Pointer getPointer() {
        return this.pointer;
    }

    protected AbstractBasicData(T lValue) {
        this.mValue = lValue;
    }

    @Override
    public T getValue() {
        return this.mValue;
    }

    public String getValueAsString() {
        if (this.mValue == null) {
            return null;
        }
        return this.mValue.toString();
    }

    public String toString() {
        if (this.mValue == null) {
            return "NULL";
        }
        return this.mValue.toString();
    }
}

