/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.test.bug;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.MemoryStatusEx;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.test.JNativeTester;

public class _1698452_mem_leak {
    private static JNative strcat;

    private static String strcat(String src1, String src2) throws NativeException, IllegalAccessException {
        if (strcat == null) {
            if (JNative.isWindows()) {
                strcat = new JNative("ntdll.dll", "strcat", false);
            } else if (JNative.isLinux()) {
                strcat = new JNative("/lib/libc.so.6", "strcat", false);
            }
            strcat.setRetVal(Type.INT);
        }
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(100));
        p.zeroMemory();
        p.setStringAt(0, src1);
        strcat.setParameter(0, p);
        strcat.setParameter(1, Type.STRING, src2);
        strcat.invoke();
        try {
            String string = p.getAsString();
            return string;
        }
        finally {
            p.dispose();
        }
    }

    public static void main(String[] args) throws IOException, NativeException, IllegalAccessException {
        System.getProperties().put("jnative.debug", "true");
        System.getProperties().put("jnative.loadNative", "manual");
        JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "1698452 bug tester");
        JNativeTester.loadLib();
        System.err.println(JNative.getNativeSideVersion());
        JNative.setLoggingEnabled(false);
        while (true) {
            String line;
            int i = 0;
            while (i < 100000) {
                try {
                    _1698452_mem_leak.strcat("toto", "" + i);
                }
                catch (NativeException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                ++i;
            }
            System.gc();
            if (JNative.isWindows()) {
                MemoryStatusEx memStatus = Kernel32.globalMemoryStatusEx();
                System.out.println("Free Memory  : Physical = " + memStatus.ullAvailPhys + ", Virtual = " + memStatus.ullAvailVirtual);
                continue;
            }
            if (!JNative.isLinux()) continue;
            BufferedReader br = new BufferedReader(new FileReader("/proc/meminfo"));
            while ((line = br.readLine()) != null) {
                if (line.toLowerCase().indexOf("free") < 0) continue;
                System.out.println(line);
            }
            br.close();
        }
    }
}

