/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc.basicStructures;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.HeapMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BITMAP
extends AbstractBasicData<BITMAP> {
    public BITMAP() {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Pointer createBitmapBuffer() throws NativeException {
        return new Pointer(new HeapMemoryBlock(this.getNeededBufferSize()));
    }

    public int getWidth() throws NativeException {
        return this.pointer.getAsInt(4);
    }

    public int getHeight() throws NativeException {
        return this.pointer.getAsInt(8);
    }

    public int getNeededBufferSize() throws NativeException {
        return this.getWidth() * this.getHeight() * 4;
    }

    public int getRealBitmapSize() throws NativeException {
        return this.getWidth() * this.getHeight();
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return 24;
    }

    @Override
    public BITMAP getValueFromPointer() {
        return this;
    }
}

