/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.FreeDiskSpace;
import org.xvolks.jnative.misc.MemoryStatusEx;
import org.xvolks.jnative.misc.SecurityAttributes;
import org.xvolks.jnative.misc.SystemInfo;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.INT64;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.HeapMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.Callback;

public class Kernel32 {
    public static final String DLL_NAME = "Kernel32.dll";
    private static JNative nOpenProcess;
    private static JNative nCloseHandle;
    private static JNative nTerminateProcess;
    private static JNative nSetLastError;
    private static JNative nCreateFileMapping;
    private static JNative nMapViewOfFileEx;
    private static JNative nGetVersion;
    private static JNative nWriteFile;
    private static JNative nReadFile;
    public static final DWORD IOCTL_STORAGE_EJECT_MEDIA;
    private static JNative WaitForSingleObjectEx;
    private static JNative WaitForMultipleObjectsEx;
    public static final int DELETE = 65536;
    public static final int READ_CONTROL = 131072;
    public static final int SYNCHRONIZE = 0x100000;
    public static final int WRITE_DAC = 262144;
    public static final int WRITE_OWNER = 524288;
    public static final int PROCESS_ALL_ACCESS = 0x1F0FFF;
    public static final int PROCESS_CREATE_PROCESS = 128;
    public static final int PROCESS_CREATE_THREAD = 2;
    public static final int PROCESS_DUP_HANDLE = 64;
    public static final int PROCESS_QUERY_INFORMATION = 1024;
    public static final int PROCESS_QUERY_LIMITED_INFORMATION = 4096;
    public static final int PROCESS_SET_QUOTA = 256;
    public static final int PROCESS_SET_INFORMATION = 512;
    public static final int PROCESS_SUSPEND_RESUME = 2048;
    public static final int PROCESS_TERMINATE = 1;
    public static final int PROCESS_VM_OPERATION = 8;
    public static final int PROCESS_VM_READ = 16;
    public static final int PROCESS_VM_WRITE = 32;

    static {
        IOCTL_STORAGE_EJECT_MEDIA = new DWORD(2967560);
        WaitForSingleObjectEx = null;
        WaitForMultipleObjectsEx = null;
    }

    public static boolean DeviceIoControl(HANDLE hDevice, DWORD dwIoControlCode, Pointer lpInBuffer, DWORD nInBufferSize, Pointer lpOutBuffer, DWORD nOutBufferSize, Pointer lpBytesReturned, Pointer lpOverlapped) throws NativeException, IllegalAccessException {
        JNative DeviceIoControl = new JNative(DLL_NAME, "DeviceIoControl");
        DeviceIoControl.setRetVal(Type.INT);
        int pos = 0;
        Pointer p = null;
        DeviceIoControl.setParameter(pos++, hDevice.getValue());
        DeviceIoControl.setParameter(pos++, dwIoControlCode.getValue());
        DeviceIoControl.setParameter(pos++, lpInBuffer);
        DeviceIoControl.setParameter(pos++, nInBufferSize.getValue());
        DeviceIoControl.setParameter(pos++, lpOutBuffer);
        DeviceIoControl.setParameter(pos++, nOutBufferSize.getValue());
        if (lpOverlapped instanceof NullPointer && lpBytesReturned instanceof NullPointer) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, "lpOverlapped is NullPointer, lpBytesReturned must not be NullPointer!");
            p = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
            DeviceIoControl.setParameter(pos++, p);
        } else {
            DeviceIoControl.setParameter(pos++, lpBytesReturned);
        }
        DeviceIoControl.setParameter(pos++, lpOverlapped);
        DeviceIoControl.invoke();
        pos = DeviceIoControl.getRetValAsInt();
        DeviceIoControl.dispose();
        if (p != null) {
            p.dispose();
        }
        return pos != 0;
    }

    public static int GlobalDeleteAtom(int atom) throws NativeException, IllegalAccessException {
        JNative GlobalDeleteAtom = new JNative(DLL_NAME, "GlobalDeleteAtom");
        GlobalDeleteAtom.setRetVal(Type.INT);
        int pos = 0;
        GlobalDeleteAtom.setParameter(pos++, atom);
        GlobalDeleteAtom.invoke();
        pos = GlobalDeleteAtom.getRetValAsInt();
        GlobalDeleteAtom.dispose();
        return pos;
    }

    public static int GlobalAddAtom(String lpString) throws NativeException, IllegalAccessException {
        JNative GlobalAddAtom = new JNative(DLL_NAME, "GlobalAddAtomA");
        GlobalAddAtom.setRetVal(Type.INT);
        int pos = 0;
        GlobalAddAtom.setParameter(pos++, lpString);
        GlobalAddAtom.invoke();
        pos = GlobalAddAtom.getRetValAsInt();
        GlobalAddAtom.dispose();
        return pos;
    }

    public static DWORD GetVersion() throws NativeException, IllegalAccessException {
        if (nGetVersion == null) {
            nGetVersion = new JNative(DLL_NAME, "GetVersion");
            nGetVersion.setRetVal(Type.INT);
        }
        nGetVersion.invoke();
        return new DWORD(nGetVersion.getRetValAsInt());
    }

    public static boolean ReadProcessMemory(HANDLE hProcess, int lpBaseAddress, Pointer lpBuffer, int len) throws NativeException, IllegalAccessException {
        JNative gms = new JNative(DLL_NAME, "ReadProcessMemory");
        gms.setRetVal(Type.INT);
        int i = 0;
        gms.setParameter(i++, hProcess.getValue());
        gms.setParameter(i++, lpBaseAddress);
        gms.setParameter(i++, lpBuffer);
        gms.setParameter(i++, len);
        gms.setParameter(i++, 0);
        gms.invoke();
        i = gms.getRetValAsInt();
        gms.dispose();
        return i != 0;
    }

    public static boolean WriteProcessMemory(HANDLE hProcess, int lpBaseAddress, Pointer lpBuffer, int len) throws NativeException, IllegalAccessException {
        JNative gms = new JNative(DLL_NAME, "WriteProcessMemory");
        gms.setRetVal(Type.INT);
        int i = 0;
        gms.setParameter(i++, hProcess.getValue());
        gms.setParameter(i++, lpBaseAddress);
        gms.setParameter(i++, lpBuffer);
        gms.setParameter(i++, len);
        gms.setParameter(i++, 0);
        gms.invoke();
        i = gms.getRetValAsInt();
        gms.dispose();
        return i != 0;
    }

    public static final MemoryStatusEx globalMemoryStatusEx() throws NativeException, IllegalAccessException {
        JNative gms = new JNative(DLL_NAME, "GlobalMemoryStatusEx");
        gms.setRetVal(Type.INT);
        MemoryStatusEx mem = new MemoryStatusEx();
        gms.setParameter(0, mem.createPointer());
        gms.invoke();
        if (Integer.parseInt(gms.getRetVal()) == 0) {
            gms.dispose();
            throw new NativeException("The function call has failed. To get extended error information, call GetLastError.");
        }
        gms.dispose();
        return mem.getValueFromPointer();
    }

    public static final boolean SetFilePointerEx(HANDLE hFile, INT64 liDistanceToMove, INT64 lpNewFilePointer, MoveMode dwMoveMethod) throws NativeException, IllegalAccessException {
        JNative SetFilePointer = new JNative(DLL_NAME, "SetFilePointerEx");
        try {
            SetFilePointer.setRetVal(Type.INT);
            int i = 0;
            SetFilePointer.setParameter(i++, hFile.getValue());
            SetFilePointer.setParameter(i++, Type.LONG, "" + liDistanceToMove.getValue());
            SetFilePointer.setParameter(i++, lpNewFilePointer.getPointer());
            SetFilePointer.setParameter(i++, dwMoveMethod.getValue());
            SetFilePointer.invoke();
            boolean bl = SetFilePointer.getRetValAsInt() != 0;
            return bl;
        }
        finally {
            if (SetFilePointer != null) {
                SetFilePointer.dispose();
            }
        }
    }

    public static final boolean ReadFile(HANDLE hFile, Pointer lpBuffer, int nNumberOfBytesToRead, DWORD lpNumberOfBytesRead, Pointer lpOverlapped) throws NativeException, IllegalAccessException {
        if (nReadFile == null) {
            nReadFile = new JNative(DLL_NAME, "ReadFile");
            nReadFile.setRetVal(Type.INT);
        }
        int i = 0;
        nReadFile.setParameter(i++, hFile.getValue());
        nReadFile.setParameter(i++, lpBuffer);
        nReadFile.setParameter(i++, nNumberOfBytesToRead);
        nReadFile.setParameter(i++, lpNumberOfBytesRead.getPointer());
        nReadFile.setParameter(i++, lpOverlapped);
        nReadFile.invoke();
        return nReadFile.getRetValAsInt() != 0;
    }

    public static final boolean WriteFile(HANDLE hFile, Pointer lpBuffer, int nNumberOfBytesToWrite, DWORD lpNumberOfBytesWritten, Pointer lpOverlapped) throws NativeException, IllegalAccessException {
        if (nWriteFile == null) {
            nWriteFile = new JNative(DLL_NAME, "WriteFile");
            nWriteFile.setRetVal(Type.INT);
        }
        int i = 0;
        nWriteFile.setParameter(i++, hFile.getValue());
        nWriteFile.setParameter(i++, lpBuffer);
        nWriteFile.setParameter(i++, nNumberOfBytesToWrite);
        nWriteFile.setParameter(i++, lpNumberOfBytesWritten.getPointer());
        nWriteFile.setParameter(i++, lpOverlapped);
        nWriteFile.invoke();
        return nWriteFile.getRetValAsInt() != 0;
    }

    public static final HANDLE CreateFile(String fileName, int desiredAccess, int shareMode, SecurityAttributes securityAttributes, int creationDisposition, int flagsAndAttributes, int templateFile) throws NativeException, IllegalAccessException {
        JNative createFile = new JNative(DLL_NAME, "CreateFileA");
        createFile.setRetVal(Type.INT);
        int i = 0;
        createFile.setParameter(i++, Type.STRING, fileName);
        createFile.setParameter(i++, Type.INT, "" + desiredAccess);
        createFile.setParameter(i++, Type.INT, "" + shareMode);
        createFile.setParameter(i++, securityAttributes == null ? NullPointer.NULL : securityAttributes.getPointer());
        createFile.setParameter(i++, Type.INT, "" + creationDisposition);
        createFile.setParameter(i++, Type.INT, "" + flagsAndAttributes);
        createFile.setParameter(i++, Type.INT, "" + templateFile);
        createFile.invoke();
        HANDLE handle = new HANDLE(Integer.parseInt(createFile.getRetVal()));
        createFile.dispose();
        return handle;
    }

    public static final HANDLE CreateFile(String fileName, AccessMask desiredAccess, ShareMode shareMode, SecurityAttributes securityAttributes, CreationDisposition creationDisposition, FileAttribute flagsAndAttributes, int templateFile) throws NativeException, IllegalAccessException {
        return Kernel32.CreateFile(fileName, desiredAccess.getValue(), shareMode.getValue(), securityAttributes, creationDisposition.getValue(), flagsAndAttributes.getValue(), templateFile);
    }

    public static final int getLastError() throws NativeException, IllegalAccessException {
        JNative lastError = null;
        try {
            lastError = new JNative(DLL_NAME, "GetLastError");
            lastError.setRetVal(Type.INT);
            lastError.invoke();
            int n = Integer.parseInt(lastError.getRetVal());
            return n;
        }
        finally {
            if (lastError != null) {
                lastError.dispose();
            }
        }
    }

    public static final SystemInfo getNativeSystemInfo() throws NativeException, IllegalAccessException {
        JNative info = new JNative(DLL_NAME, "GetNativeSystemInfo");
        Pointer lpSystemInfo = new Pointer(new HeapMemoryBlock(36));
        info.setParameter(0, lpSystemInfo);
        info.invoke();
        SystemInfo infoS = new SystemInfo(lpSystemInfo);
        lpSystemInfo.dispose();
        info.dispose();
        return infoS;
    }

    public static final String getComputerName() throws NativeException, IllegalAccessException {
        JNative v = new JNative(DLL_NAME, "GetComputerNameA");
        int i = 0;
        v.setRetVal(Type.INT);
        Pointer pName = new Pointer(new HeapMemoryBlock(1024));
        LONG pSize = new LONG(1024);
        v.setParameter(i++, pName);
        v.setParameter(i++, pSize.createPointer());
        v.invoke();
        int ret = Integer.parseInt(v.getRetVal());
        if (ret == 0) {
            throw new NativeException("GetComputerNameA failed call GetLastError()");
        }
        String name = pName.getAsString().substring(0, pSize.getValueFromPointer());
        pName.dispose();
        v.dispose();
        return name;
    }

    public static final FreeDiskSpace getDiskFreeSpaceEx(String drive) throws NativeException, IllegalAccessException {
        if (drive == null) {
            throw new NullPointerException("The drive name cannot be null !");
        }
        INT64 lFreeBytesAvailable = new INT64(0L);
        INT64 lTotalNumberOfBytes = new INT64(0L);
        INT64 lTotalNumberOfFreeBytes = new INT64(0L);
        int i = 0;
        JNative fs = new JNative(DLL_NAME, "GetDiskFreeSpaceExA");
        fs.setRetVal(Type.INT);
        fs.setParameter(i++, Type.STRING, drive);
        fs.setParameter(i++, lFreeBytesAvailable.createPointer());
        fs.setParameter(i++, lTotalNumberOfBytes.createPointer());
        fs.setParameter(i++, lTotalNumberOfFreeBytes.createPointer());
        fs.invoke();
        return new FreeDiskSpace(drive, lFreeBytesAvailable.getValueFromPointer(), lTotalNumberOfBytes.getValueFromPointer(), lTotalNumberOfFreeBytes.getValueFromPointer());
    }

    public static HANDLE OpenProcess(int dwDesiredAccess, boolean bInheritHandle, int dwProcessId) throws NativeException, IllegalAccessException {
        if (nOpenProcess == null) {
            nOpenProcess = new JNative(DLL_NAME, "OpenProcess");
            nOpenProcess.setRetVal(Type.INT);
        }
        nOpenProcess.setParameter(0, dwDesiredAccess);
        nOpenProcess.setParameter(1, bInheritHandle ? 1 : 0);
        nOpenProcess.setParameter(2, dwProcessId);
        nOpenProcess.invoke();
        int ret = Integer.parseInt(nOpenProcess.getRetVal());
        if (ret == 0) {
            return null;
        }
        return new HANDLE(ret);
    }

    public static boolean CloseHandle(HANDLE handle) throws NativeException, IllegalAccessException {
        if (nCloseHandle == null) {
            nCloseHandle = new JNative(DLL_NAME, "CloseHandle");
            nCloseHandle.setRetVal(Type.INT);
        }
        nCloseHandle.setParameter(0, handle.getValue());
        nCloseHandle.invoke();
        return !"0".equals(nCloseHandle.getRetVal());
    }

    public static boolean TerminateProcess(HANDLE lHandle, int exitCode) throws NativeException, IllegalAccessException {
        if (nTerminateProcess == null) {
            nTerminateProcess = new JNative(DLL_NAME, "TerminateProcess");
            nTerminateProcess.setRetVal(Type.INT);
        }
        nTerminateProcess.setParameter(0, lHandle.getValue());
        nTerminateProcess.setParameter(1, exitCode);
        nTerminateProcess.invoke();
        return !"0".equals(nTerminateProcess.getRetVal());
    }

    public static void SetLastError(int value) throws NativeException, IllegalAccessException {
        if (nSetLastError == null) {
            nSetLastError = new JNative(DLL_NAME, "SetLastError");
        }
        nSetLastError.setParameter(0, value);
        nSetLastError.invoke();
    }

    public static HANDLE CreateFileMapping(HANDLE hFile, SecurityAttributes lpAttributes, PageAccess flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, String lpName) throws NativeException, IllegalAccessException {
        if (nCreateFileMapping == null) {
            nCreateFileMapping = new JNative(DLL_NAME, "CreateFileMappingA");
            nCreateFileMapping.setRetVal(Type.INT);
        }
        nCreateFileMapping.setParameter(0, hFile.getValue());
        nCreateFileMapping.setParameter(1, lpAttributes == null ? NullPointer.NULL : lpAttributes.getPointer());
        nCreateFileMapping.setParameter(2, flProtect.getValue());
        nCreateFileMapping.setParameter(3, dwMaximumSizeHigh.getValue());
        nCreateFileMapping.setParameter(4, dwMaximumSizeLow.getValue());
        nCreateFileMapping.setParameter(5, lpName);
        nCreateFileMapping.invoke();
        return new HANDLE(Integer.parseInt(nCreateFileMapping.getRetVal()));
    }

    public static LONG MapViewOfFileEx(HANDLE hFileMappingObject, FileMap dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, DWORD dwNumberOfBytesToMap, LONG lpBaseAddress) throws IllegalAccessException, NativeException {
        if (nMapViewOfFileEx == null) {
            nMapViewOfFileEx = new JNative(DLL_NAME, "MapViewOfFileEx");
            nMapViewOfFileEx.setRetVal(Type.INT);
        }
        nMapViewOfFileEx.setParameter(0, hFileMappingObject.getValue());
        nMapViewOfFileEx.setParameter(1, dwDesiredAccess.getValue());
        nMapViewOfFileEx.setParameter(2, dwFileOffsetHigh.getValue());
        nMapViewOfFileEx.setParameter(3, dwFileOffsetLow.getValue());
        nMapViewOfFileEx.setParameter(4, dwNumberOfBytesToMap.getValue());
        nMapViewOfFileEx.setParameter(5, lpBaseAddress.getValue());
        nMapViewOfFileEx.invoke();
        return new HANDLE(Integer.parseInt(nMapViewOfFileEx.getRetVal()));
    }

    public static boolean IsBadReadPtr(Pointer pointer) throws NativeException, IllegalAccessException {
        JNative nIsBadReadPtr = new JNative(DLL_NAME, "IsBadReadPtr");
        nIsBadReadPtr.setRetVal(Type.INT);
        nIsBadReadPtr.setParameter(0, pointer.getPointer());
        nIsBadReadPtr.setParameter(1, pointer.getSize());
        nIsBadReadPtr.invoke();
        return "0".equals(nIsBadReadPtr.getRetVal());
    }

    public static boolean UnmapViewOfFile(LONG lpBaseAddress) throws NativeException, IllegalAccessException {
        JNative nUnmapViewOfFile = new JNative(DLL_NAME, "UnmapViewOfFile");
        nUnmapViewOfFile.setRetVal(Type.INT);
        nUnmapViewOfFile.setParameter(0, lpBaseAddress.getValue());
        nUnmapViewOfFile.invoke();
        return !"0".equals(nUnmapViewOfFile.getRetVal());
    }

    public static boolean SetConsoleCtrlHandler(Callback callback, boolean Add) throws NativeException, IllegalAccessException {
        JNative SetConsoleCtrlHandler = new JNative(DLL_NAME, "SetConsoleCtrlHandler");
        SetConsoleCtrlHandler.setRetVal(Type.INT);
        SetConsoleCtrlHandler.setParameter(0, callback.getCallbackAddress());
        SetConsoleCtrlHandler.setParameter(1, Add ? "1" : "0");
        SetConsoleCtrlHandler.invoke();
        return SetConsoleCtrlHandler.getRetValAsInt() != 0;
    }

    public static final HANDLE FindFirstChangeNotification(String lpPathName, boolean bWatchSubtree, DWORD dwNotifyFilter) throws NativeException, IllegalAccessException {
        JNative FindFirstChangeNotification = new JNative(DLL_NAME, "FindFirstChangeNotificationA");
        FindFirstChangeNotification.setRetVal(Type.INT);
        FindFirstChangeNotification.setParameter(0, lpPathName);
        FindFirstChangeNotification.setParameter(1, bWatchSubtree ? -1 : 0);
        FindFirstChangeNotification.setParameter(2, dwNotifyFilter.getValue());
        FindFirstChangeNotification.invoke();
        return new HANDLE(FindFirstChangeNotification.getRetValAsInt());
    }

    public static final boolean FindNextChangeNotification(HANDLE hChangeHandle) throws NativeException, IllegalAccessException {
        JNative FindNextChangeNotification = new JNative(DLL_NAME, "FindNextChangeNotification");
        FindNextChangeNotification.setRetVal(Type.INT);
        FindNextChangeNotification.setParameter(0, hChangeHandle.getValue());
        FindNextChangeNotification.invoke();
        return FindNextChangeNotification.getRetValAsInt() == 0;
    }

    public static final boolean FindCloseChangeNotification(HANDLE hChangeHandle) throws NativeException, IllegalAccessException {
        JNative FindCloseChangeNotification = new JNative(DLL_NAME, "FindCloseChangeNotification");
        FindCloseChangeNotification.setRetVal(Type.INT);
        FindCloseChangeNotification.setParameter(0, hChangeHandle.getValue());
        FindCloseChangeNotification.invoke();
        return FindCloseChangeNotification.getRetValAsInt() == 0;
    }

    public static final int WaitForSingleObjectEx(HANDLE hHandle, DWORD dwMilliseconds, boolean bAlertable) throws NativeException, IllegalAccessException {
        if (WaitForSingleObjectEx == null) {
            WaitForSingleObjectEx = new JNative(DLL_NAME, "WaitForSingleObjectEx");
            WaitForSingleObjectEx.setRetVal(Type.INT);
        }
        WaitForSingleObjectEx.setParameter(0, hHandle.getValue());
        WaitForSingleObjectEx.setParameter(1, dwMilliseconds.getValue());
        WaitForSingleObjectEx.setParameter(2, bAlertable ? -1 : 0);
        WaitForSingleObjectEx.invoke();
        return WaitForSingleObjectEx.getRetValAsInt();
    }

    public static final int WaitForMultipleObjectsEx(DWORD nCount, HANDLE[] lpHandles, boolean bWaitAll, DWORD dwMilliseconds, boolean bAlertable) throws NativeException, IllegalAccessException {
        if (WaitForMultipleObjectsEx == null) {
            WaitForMultipleObjectsEx = new JNative(DLL_NAME, "WaitForMultipleObjectsEx");
            WaitForMultipleObjectsEx.setRetVal(Type.INT);
        }
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(4 * lpHandles.length));
        int i = 0;
        while (i < lpHandles.length) {
            p.setIntAt(i * 4, lpHandles[i].getValue());
            ++i;
        }
        WaitForMultipleObjectsEx.setParameter(0, nCount.getValue());
        WaitForMultipleObjectsEx.setParameter(1, p);
        WaitForMultipleObjectsEx.setParameter(2, bWaitAll ? -1 : 0);
        WaitForMultipleObjectsEx.setParameter(3, dwMilliseconds.getValue());
        WaitForMultipleObjectsEx.setParameter(4, bAlertable ? -1 : 0);
        WaitForMultipleObjectsEx.invoke();
        p.dispose();
        return WaitForMultipleObjectsEx.getRetValAsInt();
    }

    public static SystemTime GetSystemTime() throws NativeException, IllegalAccessException {
        JNative nGetSystemTime = new JNative(DLL_NAME, "GetSystemTime");
        SystemTime systemTime = new SystemTime();
        nGetSystemTime.setParameter(0, systemTime.getPointer());
        nGetSystemTime.invoke();
        return systemTime.getValueFromPointer();
    }

    public static void main(String[] args) throws NativeException, IllegalAccessException {
        System.err.println(Kernel32.GetSystemTime());
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(2));
        p.setStringAt(0, "A");
        p.setByteAt(1, (byte)66);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SystemTime
    extends AbstractBasicData<SystemTime> {
        public short wYear;
        public short wMonth;
        public short wDayOfWeek;
        public short wDay;
        public short wHour;
        public short wMinute;
        public short wSecond;
        public short wMilliseconds;

        @Override
        public Pointer createPointer() throws NativeException {
            this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
            return this.pointer;
        }

        @Override
        public int getSizeOf() {
            return 16;
        }

        @Override
        public SystemTime getValueFromPointer() throws NativeException {
            this.wYear = this.getNextShort();
            this.wMonth = this.getNextShort();
            this.wDayOfWeek = this.getNextShort();
            this.wDay = this.getNextShort();
            this.wHour = this.getNextShort();
            this.wMinute = this.getNextShort();
            this.wSecond = this.getNextShort();
            this.wMilliseconds = this.getNextShort();
            return this;
        }

        public SystemTime() throws NativeException {
            super(null);
            this.createPointer();
            this.mValue = this;
        }

        @Override
        public String toString() {
            return String.valueOf(this.wYear) + "/" + this.wMonth + "/" + this.wDay + " at " + this.wHour + ":" + this.wMinute + ":" + this.wSecond + ":" + this.wMilliseconds;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileMap {
        FILE_MAP_ALL_ACCESS(983071),
        FILE_MAP_READ(4),
        FILE_MAP_WRITE(2),
        FILE_MAP_COPY(1);

        int value;

        private FileMap(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessMask {
        FILE_READ_DATA(1),
        FILE_LIST_DIRECTORY(1),
        FILE_WRITE_DATA(2),
        FILE_ADD_FILE(2),
        FILE_APPEND_DATA(4),
        FILE_ADD_SUBDIRECTORY(4),
        FILE_READ_EA(8),
        FILE_WRITE_EA(16),
        FILE_EXECUTE(32),
        FILE_TRAVERSE(32),
        FILE_DELETE_CHILD(64),
        FILE_READ_ATTRIBUTES(128),
        FILE_WRITE_ATTRIBUTES(256),
        DELETE(65536),
        READ_CONTROL(131072),
        WRITE_DAC(262144),
        WRITE_OWNER(524288),
        SYNCHRONIZE(0x100000),
        STANDARD_RIGHTS_READ(131072),
        STANDARD_RIGHTS_WRITE(131072),
        STANDARD_RIGHTS_EXECUTE(131072),
        STANDARD_RIGHTS_REQUIRED(983040),
        STANDARD_RIGHTS_ALL(0x1F0000),
        ACCESS_SYSTEM_SECURITY(0x1000000),
        MAXIMUM_ALLOWED(0x2000000),
        GENERIC_ALL(0x10000000),
        GENERIC_EXECUTE(0x20000000),
        GENERIC_WRITE(0x40000000),
        GENERIC_READ(Integer.MIN_VALUE);

        int value;

        private AccessMask(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShareMode {
        FILE_SHARE_READ(1),
        FILE_SHARE_WRITE(2),
        FILE_SHARE_DELETE(4),
        FILE_SHARE_VALID_FLAGS(7);

        int value;

        private ShareMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoveMode {
        FILE_BEGIN(0),
        FILE_CURRENT(1),
        FILE_END(2);

        int value;

        private MoveMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreationDisposition {
        CREATE_NEW(1),
        CREATE_ALWAYS(2),
        OPEN_EXISTING(3),
        OPEN_ALWAYS(4),
        TRUNCATE_EXISTING(5);

        int value;

        private CreationDisposition(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageAccess {
        PAGE_NOACCESS(1),
        PAGE_READONLY(2),
        PAGE_READWRITE(4),
        PAGE_WRITECOPY(8),
        PAGE_EXECUTE(16),
        PAGE_EXECUTE_READ(32),
        PAGE_EXECUTE_READWRITE(64),
        PAGE_EXECUTE_WRITECOPY(128),
        PAGE_GUARD(256),
        PAGE_NOCACHE(512),
        PAGE_WRITECOMBINE(1024);

        int value;

        private PageAccess(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileAttribute {
        FILE_ATTRIBUTE_READONLY(1),
        FILE_ATTRIBUTE_HIDDEN(2),
        FILE_ATTRIBUTE_SYSTEM(4),
        FILE_ATTRIBUTE_DIRECTORY(16),
        FILE_ATTRIBUTE_ARCHIVE(32),
        FILE_ATTRIBUTE_DEVICE(64),
        FILE_ATTRIBUTE_NORMAL(128),
        FILE_ATTRIBUTE_TEMPORARY(256),
        FILE_ATTRIBUTE_SPARSE_FILE(512),
        FILE_ATTRIBUTE_REPARSE_POINT(1024),
        FILE_ATTRIBUTE_COMPRESSED(2048),
        FILE_ATTRIBUTE_OFFLINE(4096),
        FILE_ATTRIBUTE_NOT_CONTENT_INDEXED(8192),
        FILE_ATTRIBUTE_ENCRYPTED(16384),
        FILE_ATTRIBUTE_VALID_FLAGS(32695),
        FILE_ATTRIBUTE_VALID_SET_FLAGS(12711);

        int value;

        private FileAttribute(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileFlags {
        FILE_FLAG_DELETE_ON_CLOSE(0x4000000),
        FILE_FLAG_NO_BUFFERING(0x20000000),
        FILE_FLAG_OVERLAPPED(0x40000000),
        FILE_FLAG_POSIX_SEMANTICS(0x1000000),
        FILE_FLAG_RANDOM_ACCESS(0x10000000),
        FILE_FLAG_SEQUENTIAL_SCAN(0x8000000),
        FILE_FLAG_WRITE_THROUGH(Integer.MIN_VALUE);

        int value;

        private FileFlags(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

