/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.logging;

import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.logging.AbstractLogger;
import org.xvolks.jnative.logging.JNativeLogger;

public class SimpleFileLogger
extends AbstractLogger {
    private Logger logger = null;

    private SimpleFileLogger() {
        this.logger = new FileLogger(null, null);
    }

    private SimpleFileLogger(String name) {
        this.logger = new FileLogger(name, null);
    }

    public static JNativeLogger getInstance(Class clazz) {
        return SimpleFileLogger.getInstance(clazz.getSimpleName());
    }

    public static JNativeLogger getInstance(String name) {
        JNativeLogger logger = null;
        if (!loggers.containsKey(name)) {
            logger = new SimpleFileLogger(name);
            loggers.put(name, logger);
        } else {
            logger = (JNativeLogger)loggers.get(name);
        }
        return logger;
    }

    public void log(Object message) {
        if (!JNative.isLogginEnabled()) {
            return;
        }
        if (message != null) {
            this.logger.log(Level.ALL, message.toString());
        }
    }

    public void log(JNativeLogger.SEVERITY severity, Object message) {
        this.log(message);
    }

    private class FileLogger
    extends Logger {
        private FileHandler fh;

        public FileLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
            this.fh = null;
            try {
                this.fh = new FileHandler(String.valueOf(this.getName()) + ".log", true);
                this.fh.setFormatter(new SimpleFormatter());
                this.addHandler(this.fh);
                this.setLevel(Level.ALL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

