/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.GlobalMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WNDCLASS
extends AbstractBasicData<WNDCLASS> {
    private LONG style = new LONG(0);
    private LONG lpfnWndProc = new LONG(0);
    private int cbClsExtra = 0;
    private int cbWndExtra = 0;
    private LONG hInstance = new LONG(0);
    private LONG hIcon = new LONG(0);
    private LONG hCursor = new LONG(0);
    private LONG hbrBackground = new LONG(0);
    private String lpszMenuName = null;
    private String lpszClassName = null;
    private final Pointer lpszMenuNamePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(512));
    private final Pointer lpszClassNamePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(512));

    public WNDCLASS() throws NativeException {
        this(null);
    }

    protected WNDCLASS(WNDCLASS lValue) throws NativeException {
        super(lValue);
    }

    private void toPointer() throws NativeException {
        int offset = 0;
        offset += this.pointer.setIntAt(offset, this.style.getValue());
        offset += this.pointer.setIntAt(offset, this.lpfnWndProc.getValue());
        offset += this.pointer.setIntAt(offset, this.cbClsExtra);
        offset += this.pointer.setIntAt(offset, this.cbWndExtra);
        offset += this.pointer.setIntAt(offset, this.hInstance.getValue());
        offset += this.pointer.setIntAt(offset, this.hIcon.getValue());
        offset += this.pointer.setIntAt(offset, this.hCursor.getValue());
        offset += this.pointer.setIntAt(offset, this.hbrBackground.getValue());
        if (this.lpszClassName != null) {
            this.lpszClassNamePointer.setStringAt(0, this.lpszClassName);
        }
        if (this.lpszMenuName != null) {
            this.lpszMenuNamePointer.setStringAt(0, this.lpszMenuName);
        }
        offset += this.pointer.setIntAt(offset, this.lpszMenuName == null ? NullPointer.NULL.getPointer() : this.lpszMenuNamePointer.getPointer());
        offset += this.pointer.setIntAt(offset, this.lpszClassName == null ? NullPointer.NULL.getPointer() : this.lpszClassNamePointer.getPointer());
    }

    private void fromPointer() throws NativeException {
        this.style = new LONG(this.getNextInt());
        this.lpfnWndProc = new LONG(this.getNextInt());
        this.cbClsExtra = this.getNextShort();
        this.cbWndExtra = this.getNextShort();
        this.hInstance = new LONG(this.getNextInt());
        this.hIcon = new LONG(this.getNextInt());
        this.hCursor = new LONG(this.getNextInt());
        this.hbrBackground = new LONG(this.getNextInt());
        this.hCursor = new LONG(this.getNextInt());
        this.lpszClassName = this.lpszClassNamePointer.getAsString();
        this.lpszMenuName = this.lpszMenuNamePointer.getAsString();
    }

    @Override
    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = new Pointer(new GlobalMemoryBlock(this.getSizeOf()));
        }
        this.toPointer();
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return 40;
    }

    @Override
    public WNDCLASS getValueFromPointer() throws NativeException {
        this.fromPointer();
        return this;
    }

    public int getCbClsExtra() {
        return this.cbClsExtra;
    }

    public void setCbClsExtra(int cbClsExtra) {
        this.cbClsExtra = cbClsExtra;
    }

    public int getCbWndExtra() {
        return this.cbWndExtra;
    }

    public void setCbWndExtra(int cbWndExtra) {
        this.cbWndExtra = cbWndExtra;
    }

    public LONG getHbrBackground() {
        return this.hbrBackground;
    }

    public void setHbrBackground(LONG hbrBackground) {
        this.hbrBackground = hbrBackground;
    }

    public LONG getHCursor() {
        return this.hCursor;
    }

    public void setHCursor(LONG cursor) {
        this.hCursor = cursor;
    }

    public LONG getHIcon() {
        return this.hIcon;
    }

    public void setHIcon(LONG icon) {
        this.hIcon = icon;
    }

    public LONG getHInstance() {
        return this.hInstance;
    }

    public void setHInstance(LONG instance) {
        this.hInstance = instance;
    }

    public LONG getLpfnWndProc() {
        return this.lpfnWndProc;
    }

    public void setLpfnWndProc(LONG lpfnWndProc) {
        this.lpfnWndProc = lpfnWndProc;
    }

    public String getLpszClassName() {
        return this.lpszClassName;
    }

    public void setLpszClassName(String lpszClassName) {
        this.lpszClassName = lpszClassName;
    }

    public String getLpszMenuName() {
        return this.lpszMenuName;
    }

    public void setLpszMenuName(String lpszMenuName) {
        this.lpszMenuName = lpszMenuName;
    }

    public LONG getStyle() {
        return this.style;
    }

    public void setStyle(LONG style) {
        this.style = style;
    }
}

