/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.HKEY;
import org.xvolks.jnative.misc.REGSAM;
import org.xvolks.jnative.misc.basicStructures.TOKEN_PRIVILEGES;
import org.xvolks.jnative.misc.registry.REGTYPE;
import org.xvolks.jnative.misc.registry.RegData;
import org.xvolks.jnative.misc.registry.RegKey;
import org.xvolks.jnative.misc.registry.RegQueryKey;
import org.xvolks.jnative.misc.registry.RegValue;
import org.xvolks.jnative.misc.registry.RegValueTypes;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class Advapi32 {
    public static final String DLL_NAME = "Advapi32.dll.";
    private static String mLastErrorCode = "0";
    private static JNative nRegOpenKeyEx;
    private static JNative nRegCloseKey;
    private static JNative nRegEnumKey;
    private static JNative nRegQueryInfoKey;
    private static JNative nRegQueryValueEx;
    private static JNative nRegGetValue;
    private static JNative nRegEnumValue;
    private static JNative nRegCreateKeyEx;
    private static JNative nRegSetValueExA;
    private static JNative nRegDeleteKey;
    private static JNative nRegDeleteValue;
    private static JNative nOpenProcessToken;
    private static JNative nGetCurrentProcess;
    private static JNative nLookupPrivilegeValue;
    private static JNative nAdjustTokenPrivileges;
    static int cpt;

    static {
        cpt = 0;
    }

    public static boolean AdjustTokenPrivileges(int TokenHandle, boolean DisableAllPrivileges, TOKEN_PRIVILEGES NewState) throws NativeException, IllegalAccessException {
        if (nAdjustTokenPrivileges == null) {
            nAdjustTokenPrivileges = new JNative(DLL_NAME, "AdjustTokenPrivileges");
            nAdjustTokenPrivileges.setRetVal(Type.INT);
        }
        int i = 0;
        nAdjustTokenPrivileges.setParameter(i++, TokenHandle);
        nAdjustTokenPrivileges.setParameter(i++, DisableAllPrivileges ? -1 : 0);
        nAdjustTokenPrivileges.setParameter(i++, NewState.getPointer());
        nAdjustTokenPrivileges.setParameter(i++, 0);
        nAdjustTokenPrivileges.setParameter(i++, NullPointer.NULL);
        nAdjustTokenPrivileges.setParameter(i++, 0);
        nAdjustTokenPrivileges.invoke();
        mLastErrorCode = nAdjustTokenPrivileges.getRetVal();
        return !"0".equals(mLastErrorCode);
    }

    public static int LookupPrivilegeValue(String lpSystemName, String lpName) throws NativeException, IllegalAccessException {
        if (nLookupPrivilegeValue == null) {
            nLookupPrivilegeValue = new JNative(DLL_NAME, "LookupPrivilegeValueA");
            nLookupPrivilegeValue.setRetVal(Type.INT);
        }
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(4));
        int i = 0;
        nLookupPrivilegeValue.setParameter(i++, lpSystemName);
        nLookupPrivilegeValue.setParameter(i++, lpName);
        nLookupPrivilegeValue.setParameter(i++, p.getPointer());
        nLookupPrivilegeValue.invoke();
        mLastErrorCode = nLookupPrivilegeValue.getRetVal();
        int ret = p.getAsInt(0);
        p.dispose();
        return ret;
    }

    public static int OpenProcessToken(int ProcessHandle2, int DesiredAccess) throws NativeException, IllegalAccessException {
        if (nOpenProcessToken == null) {
            nOpenProcessToken = new JNative(DLL_NAME, "OpenProcessToken");
            nOpenProcessToken.setRetVal(Type.INT);
        }
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(4));
        int i = 0;
        nOpenProcessToken.setParameter(i++, ProcessHandle2);
        nOpenProcessToken.setParameter(i++, DesiredAccess);
        nOpenProcessToken.setParameter(i++, p);
        nOpenProcessToken.invoke();
        mLastErrorCode = nOpenProcessToken.getRetVal();
        int ret = p.getAsInt(0);
        p.dispose();
        return ret;
    }

    public static int GetCurrentProcess() throws NativeException, IllegalAccessException {
        if (nGetCurrentProcess == null) {
            nGetCurrentProcess = new JNative("kernel32.dll", "GetCurrentProcess");
            nGetCurrentProcess.setRetVal(Type.INT);
        }
        nGetCurrentProcess.invoke();
        return Integer.parseInt(nGetCurrentProcess.getRetVal());
    }

    public static boolean RegDeleteValue(HKEY hKey, String lpSubKey) throws NativeException, IllegalAccessException {
        if (nRegDeleteValue == null) {
            nRegDeleteValue = new JNative(DLL_NAME, "RegDeleteValueA");
            nRegDeleteValue.setRetVal(Type.INT);
        }
        int i = 0;
        nRegDeleteValue.setParameter(i++, hKey.getValue());
        nRegDeleteValue.setParameter(i++, Type.STRING, lpSubKey);
        nRegDeleteValue.invoke();
        mLastErrorCode = nRegDeleteValue.getRetVal();
        return "0".equals(mLastErrorCode);
    }

    public static boolean RegDeleteKey(HKEY hKey, String lpSubKey) throws NativeException, IllegalAccessException {
        if (nRegDeleteKey == null) {
            nRegDeleteKey = new JNative(DLL_NAME, "RegDeleteKeyA");
            nRegDeleteKey.setRetVal(Type.INT);
        }
        int i = 0;
        nRegDeleteKey.setParameter(i++, hKey.getValue());
        nRegDeleteKey.setParameter(i++, Type.STRING, lpSubKey);
        nRegDeleteKey.invoke();
        mLastErrorCode = nRegDeleteKey.getRetVal();
        return "0".equals(mLastErrorCode);
    }

    public static boolean RegSetValueEx(HKEY hKey, String lpValueName, String value, REGTYPE type) throws Exception {
        if (nRegSetValueExA == null) {
            nRegSetValueExA = new JNative(DLL_NAME, "RegSetValueExA");
            nRegSetValueExA.setRetVal(Type.INT);
        }
        int i = 0;
        nRegSetValueExA.setParameter(i++, hKey.getValue());
        nRegSetValueExA.setParameter(i++, Type.STRING, lpValueName);
        nRegSetValueExA.setParameter(i++, 0);
        nRegSetValueExA.setParameter(i++, type.getValue());
        if (type.equals(REGTYPE.REG_DWORD)) {
            nRegSetValueExA.setParameter(i++, Type.STRING, Advapi32.getBytes(Integer.parseInt(value)));
            nRegSetValueExA.setParameter(i++, type.getSize());
        } else {
            nRegSetValueExA.setParameter(i++, Type.STRING, value);
            nRegSetValueExA.setParameter(i++, value.length());
        }
        nRegSetValueExA.invoke();
        mLastErrorCode = nRegSetValueExA.getRetVal();
        return "0".equals(mLastErrorCode);
    }

    public static final byte[] getBytes(int value) {
        byte[] x = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        return x;
    }

    public static HKEY RegCreateKeyEx(HKEY hKey, String lpSubKey, REGSAM samDesired) throws NativeException, IllegalAccessException {
        if (nRegCreateKeyEx == null) {
            nRegCreateKeyEx = new JNative(DLL_NAME, "RegCreateKeyExA");
            nRegCreateKeyEx.setRetVal(Type.INT);
        }
        HKEY phkResult = new HKEY(0);
        int i = 0;
        nRegCreateKeyEx.setParameter(i++, hKey.getValue());
        nRegCreateKeyEx.setParameter(i++, Type.STRING, lpSubKey);
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, samDesired.getValue());
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, phkResult.getPointer());
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.invoke();
        mLastErrorCode = nRegCreateKeyEx.getRetVal();
        if ("0".equals(mLastErrorCode)) {
            return phkResult;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doesKeyExist(HKEY base, String regKey) throws Exception {
        HKEY key;
        block4: {
            key = null;
            try {
                key = Advapi32.RegOpenKeyEx(base, regKey, REGSAM.KEY_READ);
                if (key == null) break block4;
            }
            catch (Throwable throwable) {
                Advapi32.closeKey(key);
                throw throwable;
            }
            {
                catch (Exception e) {
                    throw e;
                }
            }
            Advapi32.closeKey(key);
            return true;
        }
        Advapi32.closeKey(key);
        return false;
    }

    public static void closeKey(HKEY key) {
        try {
            if (key != null) {
                Advapi32.RegCloseKey(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getLastErrorCode() {
        try {
            return Integer.parseInt(mLastErrorCode);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static HKEY RegOpenKeyEx(HKEY key, String lpSubKey, REGSAM samDesired) throws NativeException, IllegalAccessException {
        if (nRegOpenKeyEx == null) {
            nRegOpenKeyEx = new JNative(DLL_NAME, "RegOpenKeyExA");
            nRegOpenKeyEx.setRetVal(Type.INT);
        }
        HKEY phkResult = new HKEY(0);
        nRegOpenKeyEx.setParameter(0, key.getValue());
        nRegOpenKeyEx.setParameter(1, Type.STRING, lpSubKey);
        nRegOpenKeyEx.setParameter(2, 0);
        nRegOpenKeyEx.setParameter(3, samDesired.getValue());
        nRegOpenKeyEx.setParameter(4, phkResult.getPointer());
        nRegOpenKeyEx.invoke();
        mLastErrorCode = nRegOpenKeyEx.getRetVal();
        if ("0".equals(mLastErrorCode)) {
            return phkResult;
        }
        return null;
    }

    public static boolean RegCloseKey(HKEY hKey) throws NativeException, IllegalAccessException {
        if (nRegCloseKey == null) {
            nRegCloseKey = new JNative(DLL_NAME, "RegCloseKey");
            nRegCloseKey.setRetVal(Type.INT);
        }
        nRegCloseKey.setParameter(0, hKey.getValue());
        nRegCloseKey.invoke();
        mLastErrorCode = nRegCloseKey.getRetVal();
        return "0".equals(mLastErrorCode);
    }

    public static RegKey RegEnumKeyEx(HKEY hKey, int dwIndex, RegKey lKey) throws NativeException, IllegalAccessException {
        if (lKey == null) {
            lKey = new RegKey(255, 1024);
        }
        if (nRegEnumKey == null) {
            nRegEnumKey = new JNative(DLL_NAME, "RegEnumKeyExA");
            nRegEnumKey.setRetVal(Type.INT);
        }
        int cur = 0;
        nRegEnumKey.setParameter(cur++, hKey.getValue());
        nRegEnumKey.setParameter(cur++, dwIndex);
        nRegEnumKey.setParameter(cur++, lKey.getLpValueName());
        nRegEnumKey.setParameter(cur++, lKey.getLpcValueName().getPointer());
        nRegEnumKey.setParameter(cur++, NullPointer.NULL);
        nRegEnumKey.setParameter(cur++, lKey.getLpData());
        nRegEnumKey.setParameter(cur++, lKey.getLpcbData().getPointer());
        nRegEnumKey.setParameter(cur++, lKey.getLpLastWriteTime().getPointer());
        nRegEnumKey.invoke();
        mLastErrorCode = nRegEnumKey.getRetVal();
        lKey.setErrorCode(Advapi32.getLastErrorCode());
        return lKey;
    }

    public static RegQueryKey RegQueryInfoKey(HKEY hKey, RegQueryKey lKey) throws NativeException, IllegalAccessException {
        if (lKey == null) {
            lKey = new RegQueryKey(1024);
        }
        if (nRegQueryInfoKey == null) {
            nRegQueryInfoKey = new JNative(DLL_NAME, "RegQueryInfoKeyA");
            nRegQueryInfoKey.setRetVal(Type.INT);
        }
        int cur = 0;
        nRegQueryInfoKey.setParameter(cur++, hKey.getValue());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpData());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcbData().getPointer());
        nRegQueryInfoKey.setParameter(cur++, NullPointer.NULL);
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcSubKeys().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxSubKeyLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxClassLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcValues().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxValueNameLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxValueLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcbSecurityDescriptor().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpLastWriteTime().getPointer());
        nRegQueryInfoKey.invoke();
        mLastErrorCode = nRegQueryInfoKey.getRetVal();
        lKey.setErrorCode(Advapi32.getLastErrorCode());
        return lKey;
    }

    public static RegData RegQueryValueEx(HKEY hKey, String lpValueName, RegData lRegData) throws NativeException, IllegalAccessException {
        if (lRegData == null) {
            lRegData = new RegData(1024);
        }
        if (nRegQueryValueEx == null) {
            nRegQueryValueEx = new JNative(DLL_NAME, "RegQueryValueExA");
            nRegQueryValueEx.setRetVal(Type.INT);
        }
        nRegQueryValueEx.setParameter(0, hKey.getValue());
        nRegQueryValueEx.setParameter(1, Type.STRING, lpValueName);
        nRegQueryValueEx.setParameter(2, NullPointer.NULL);
        nRegQueryValueEx.setParameter(3, lRegData.getLpType().getPointer());
        nRegQueryValueEx.setParameter(4, lRegData.getLpData());
        nRegQueryValueEx.setParameter(5, lRegData.getLpcbData().getPointer());
        nRegQueryValueEx.invoke();
        mLastErrorCode = nRegQueryValueEx.getRetVal();
        lRegData.setErrorCode(Advapi32.getLastErrorCode());
        return lRegData;
    }

    public static RegData RegGetValue(HKEY hKey, String lpSubKey, String lpValue, int dwFlags, RegData lRegData) throws NativeException, IllegalAccessException {
        if (lRegData == null) {
            lRegData = new RegData(1024);
        }
        if (nRegGetValue == null) {
            nRegGetValue = new JNative(DLL_NAME, "RegGetValueA");
            nRegGetValue.setRetVal(Type.INT);
        }
        int cur = 0;
        nRegGetValue.setParameter(cur++, hKey.getValue());
        if (lpSubKey == null) {
            nRegGetValue.setParameter(cur++, NullPointer.NULL);
        } else {
            nRegGetValue.setParameter(cur++, Type.STRING, lpSubKey);
        }
        if (lpValue == null) {
            nRegGetValue.setParameter(cur++, NullPointer.NULL);
        } else {
            nRegGetValue.setParameter(cur++, Type.STRING, lpValue);
        }
        nRegGetValue.setParameter(cur++, dwFlags);
        nRegGetValue.setParameter(cur++, lRegData.getLpType().getPointer());
        nRegGetValue.setParameter(cur++, lRegData.getLpData());
        nRegGetValue.setParameter(cur++, lRegData.getLpcbData().getPointer());
        nRegGetValue.invoke();
        mLastErrorCode = nRegGetValue.getRetVal();
        lRegData.setErrorCode(Advapi32.getLastErrorCode());
        return lRegData;
    }

    public static RegValue RegEnumValue(HKEY hKey, int dwIndex, RegValue lRegValue) throws NativeException, IllegalAccessException {
        if (lRegValue == null) {
            lRegValue = new RegValue(512, 1024);
        }
        if (nRegEnumValue == null) {
            nRegEnumValue = new JNative(DLL_NAME, "RegEnumValueA");
            nRegEnumValue.setRetVal(Type.INT);
        }
        nRegEnumValue.setParameter(0, hKey.getValue());
        nRegEnumValue.setParameter(1, dwIndex);
        nRegEnumValue.setParameter(2, lRegValue.getLpValueName());
        nRegEnumValue.setParameter(3, lRegValue.getLpcValueName().getPointer());
        nRegEnumValue.setParameter(4, NullPointer.NULL);
        nRegEnumValue.setParameter(5, lRegValue.getLpType().getPointer());
        nRegEnumValue.setParameter(6, lRegValue.getLpData());
        nRegEnumValue.setParameter(7, lRegValue.getLpcbData().getPointer());
        nRegEnumValue.invoke();
        mLastErrorCode = nRegEnumValue.getRetVal();
        lRegValue.setErrorCode(Advapi32.getLastErrorCode());
        return lRegValue;
    }

    public static void main(String[] args) throws NativeException, IllegalAccessException {
        System.err.println("Testing Registry access");
        HKEY hKey = Advapi32.RegOpenKeyEx(HKEY.HKEY_CLASSES_ROOT, "CLSID", REGSAM.KEY_READ.or(REGSAM.KEY_QUERY_VALUE));
        if (hKey == null) {
            System.err.println("error : " + Advapi32.getLastErrorCode());
            return;
        }
        System.err.println("hKey : " + hKey.getValue());
        Advapi32.listKey(hKey);
        Advapi32.RegCloseKey(hKey);
    }

    public static void listKey(HKEY hKey) throws NativeException, IllegalAccessException {
        if (cpt > 50) {
            return;
        }
        RegQueryKey lKey = Advapi32.RegQueryInfoKey(hKey, null);
        int i = 0;
        while (i < lKey.getLpcValues().getValue()) {
            RegValue regValue = Advapi32.RegEnumValue(hKey, i, null);
            RegData lRegData = null;
            String keyValueName = regValue.getLpValueName().getAsString();
            if (keyValueName == null || keyValueName.length() == 0) {
                System.err.println("Query value : (default)");
            } else {
                System.err.println("Query value : " + keyValueName);
            }
            lRegData = Advapi32.RegQueryValueEx(hKey, keyValueName, null);
            String val = "";
            RegValueTypes valType = RegValueTypes.fromInt(lRegData.getLpType().getValue());
            switch (valType) {
                case REG_DWORD: {
                    val = String.valueOf(lRegData.getLpData().getAsInt(0)) + " - (0x" + Integer.toHexString(lRegData.getLpData().getAsInt(0)) + ")";
                    break;
                }
                case REG_DWORD_LITTLE_ENDIAN: {
                    val = String.valueOf(lRegData.getLpData().getAsShort(0) + 256 * lRegData.getLpData().getAsShort(2));
                    break;
                }
                case REG_BINARY: {
                    byte[] p = lRegData.getLpData().getMemory();
                    int j = 0;
                    while (j < lRegData.getLpcbData().getValue()) {
                        val = String.valueOf(val) + "0x" + Integer.toHexString(p[j]) + ", ";
                        ++j;
                    }
                    val = val.substring(0, val.length() - 2);
                    break;
                }
                default: {
                    val = lRegData.getLpData().getAsString();
                }
            }
            System.err.println("Type : " + (Object)((Object)valType));
            System.err.println("Value : " + val);
            ++i;
        }
        i = 0;
        while (i < lKey.getLpcSubKeys().getValue()) {
            RegKey regKey = Advapi32.RegEnumKeyEx(hKey, i, null);
            if (regKey.getErrorCode() != 0 || cpt > 50) break;
            System.err.println("Key : " + regKey.getLpValueName().getAsString());
            HKEY lhKey = Advapi32.RegOpenKeyEx(hKey, regKey.getLpValueName().getAsString(), REGSAM.KEY_READ.or(REGSAM.KEY_QUERY_VALUE));
            Advapi32.listKey(lhKey);
            Advapi32.RegCloseKey(lhKey);
            ++i;
        }
    }
}

