/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.BITMAP;
import org.xvolks.jnative.misc.basicStructures.BITMAPINFOHEADER;
import org.xvolks.jnative.misc.basicStructures.DC;
import org.xvolks.jnative.misc.basicStructures.ICONINFO;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.util.StructConverter;
import org.xvolks.jnative.util.User32;

public class Gdi32 {
    public static final String DLL_NAME = "Gdi32.dll";
    public static final int DIB_RGB_COLORS = 0;
    public static final int SRCCOPY = 0xCC0020;

    public static LONG GetStockObject(int fnObject) throws NativeException, IllegalAccessException {
        JNative getStockObject = new JNative(DLL_NAME, "GetStockObject");
        getStockObject.setRetVal(Type.INT);
        getStockObject.setParameter(0, fnObject);
        getStockObject.invoke();
        return new LONG(getStockObject.getRetValAsInt());
    }

    public static int GetObject(int handle, int size, BITMAP info) throws NativeException, IllegalAccessException {
        JNative GetObject = new JNative(DLL_NAME, "GetObjectA");
        GetObject.setRetVal(Type.INT);
        GetObject.setParameter(0, handle);
        GetObject.setParameter(1, size);
        GetObject.setParameter(2, info.getPointer());
        GetObject.invoke();
        return GetObject.getRetValAsInt();
    }

    public static boolean DeleteDC(DC hdc) throws NativeException, IllegalAccessException {
        JNative DeleteDC = new JNative(DLL_NAME, "DeleteDC");
        try {
            DeleteDC.setRetVal(Type.INT);
            DeleteDC.setParameter(0, hdc.getValue());
            DeleteDC.invoke();
            boolean bl = DeleteDC.getRetValAsInt() != 0;
            return bl;
        }
        finally {
            if (DeleteDC != null) {
                DeleteDC.dispose();
            }
        }
    }

    public static DC CreateCompatibleDC(DC hdc) throws NativeException, IllegalAccessException {
        JNative CreateCompatibleDC = new JNative(DLL_NAME, "CreateCompatibleDC");
        try {
            CreateCompatibleDC.setRetVal(Type.INT);
            CreateCompatibleDC.setParameter(0, hdc.getValue());
            CreateCompatibleDC.invoke();
            DC dC = new DC(CreateCompatibleDC.getRetValAsInt());
            return dC;
        }
        finally {
            if (CreateCompatibleDC != null) {
                CreateCompatibleDC.dispose();
            }
        }
    }

    public static int GetDIBits(DC hdc, int hbmp, int uStartScan, int cScanLines, Pointer lpvBits, BITMAPINFOHEADER lpbi, int uUsage) throws NativeException, IllegalAccessException {
        JNative GetDIBits = new JNative(DLL_NAME, "GetDIBits");
        try {
            GetDIBits.setRetVal(Type.INT);
            int i = 0;
            GetDIBits.setParameter(i++, hdc.getValue());
            GetDIBits.setParameter(i++, hbmp);
            GetDIBits.setParameter(i++, uStartScan);
            GetDIBits.setParameter(i++, lpvBits);
            GetDIBits.setParameter(i++, lpbi.getPointer());
            GetDIBits.setParameter(i++, uUsage);
            GetDIBits.invoke();
            int n = GetDIBits.getRetValAsInt();
            return n;
        }
        finally {
            if (GetDIBits != null) {
                GetDIBits.dispose();
            }
        }
    }

    public static boolean BitBlt(DC hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, DC hdcSrc, int nXSrc, int nYSrc, int dwRop) throws NativeException, IllegalAccessException {
        JNative BitBlt = new JNative(DLL_NAME, "BitBlt");
        try {
            BitBlt.setRetVal(Type.INT);
            int i = 0;
            BitBlt.setParameter(i++, hdcDest.getValue());
            BitBlt.setParameter(i++, nXDest);
            BitBlt.setParameter(i++, nYDest);
            BitBlt.setParameter(i++, nWidth);
            BitBlt.setParameter(i++, nHeight);
            BitBlt.setParameter(i++, hdcSrc.getValue());
            BitBlt.setParameter(i++, nXSrc);
            BitBlt.setParameter(i++, nYSrc);
            BitBlt.setParameter(i++, dwRop);
            BitBlt.invoke();
            boolean bl = BitBlt.getRetValAsInt() != 0;
            return bl;
        }
        finally {
            if (BitBlt != null) {
                BitBlt.dispose();
            }
        }
    }

    public static int SelectObject(DC hdc, int hgdiobj) throws NativeException, IllegalAccessException {
        JNative SelectObject = new JNative(DLL_NAME, "SelectObject");
        try {
            SelectObject.setRetVal(Type.INT);
            int i = 0;
            SelectObject.setParameter(i++, hdc.getValue());
            SelectObject.setParameter(i++, hgdiobj);
            SelectObject.invoke();
            int n = SelectObject.getRetValAsInt();
            return n;
        }
        finally {
            if (SelectObject != null) {
                SelectObject.dispose();
            }
        }
    }

    public static boolean DeleteObject(int hObject) throws NativeException, IllegalAccessException {
        JNative DeleteObject = new JNative(DLL_NAME, "DeleteObject");
        try {
            DeleteObject.setRetVal(Type.INT);
            int i = 0;
            DeleteObject.setParameter(i++, hObject);
            DeleteObject.invoke();
            boolean bl = DeleteObject.getRetValAsInt() != 0;
            return bl;
        }
        finally {
            if (DeleteObject != null) {
                DeleteObject.dispose();
            }
        }
    }

    public static int CreateCompatibleBitmap(DC hdc, int nWidth, int nHeight) throws NativeException, IllegalAccessException {
        JNative CreateCompatibleBitmap = new JNative(DLL_NAME, "CreateCompatibleBitmap");
        try {
            CreateCompatibleBitmap.setRetVal(Type.INT);
            int i = 0;
            CreateCompatibleBitmap.setParameter(i++, hdc.getValue());
            CreateCompatibleBitmap.setParameter(i++, nWidth);
            CreateCompatibleBitmap.setParameter(i++, nHeight);
            CreateCompatibleBitmap.invoke();
            int n = CreateCompatibleBitmap.getRetValAsInt();
            return n;
        }
        finally {
            if (CreateCompatibleBitmap != null) {
                CreateCompatibleBitmap.dispose();
            }
        }
    }

    public static int GetBitmapBits(int hbmp, int cbBuffer, Pointer lpvBits) throws NativeException, IllegalAccessException {
        JNative GetBitmapBits = new JNative(DLL_NAME, "GetBitmapBits");
        try {
            GetBitmapBits.setRetVal(Type.INT);
            int i = 0;
            GetBitmapBits.setParameter(i++, hbmp);
            GetBitmapBits.setParameter(i++, cbBuffer);
            GetBitmapBits.setParameter(i++, lpvBits);
            GetBitmapBits.invoke();
            int n = GetBitmapBits.getRetValAsInt();
            return n;
        }
        finally {
            if (GetBitmapBits != null) {
                GetBitmapBits.dispose();
            }
        }
    }

    public static ImageIcon iconHandleToImageIcon(LONG hIcon, boolean destroyIconHandle) throws NativeException, IllegalAccessException {
        ICONINFO info = new ICONINFO();
        if (!User32.GetIconInfo(hIcon, info)) {
            throw new RuntimeException("User32.GetIconInfo: Could not retrieve IconInfo!");
        }
        if (destroyIconHandle) {
            User32.DestroyIcon(hIcon);
        }
        BITMAP hBitmap = new BITMAP();
        Gdi32.GetObject(info.getBitmapColor(), hBitmap.getSizeOf(), hBitmap);
        Pointer bitmap = hBitmap.createBitmapBuffer();
        Gdi32.GetBitmapBits(info.getBitmapColor(), bitmap.getSize(), bitmap);
        int[] pixels = new int[hBitmap.getRealBitmapSize()];
        byte[] b_Bitmap = bitmap.getMemory();
        int i = 0;
        while (i <= pixels.length - 4) {
            pixels[i] = StructConverter.bytesIntoInt(b_Bitmap, i * 4);
            ++i;
        }
        MemoryImageSource mis = new MemoryImageSource(hBitmap.getWidth(), hBitmap.getHeight(), pixels, 0, hBitmap.getWidth());
        Image _image = Toolkit.getDefaultToolkit().createImage(mis);
        mis = null;
        pixels = null;
        b_Bitmap = null;
        info.dispose();
        bitmap.dispose();
        hBitmap.getPointer().dispose();
        return new ImageIcon(_image);
    }
}

