/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.WNDCLASS;
import org.xvolks.jnative.misc.basicStructures.DC;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.ICONINFO;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.LRESULT;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.Callback;

public class User32 {
    public static final String DLL_NAME = "User32.dll";
    private static JNative nEnumWindows;
    private static JNative nGetWindowText;
    private static Pointer nBufferGWT;
    private static JNative getProcessHandle;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_SHOWWINDOW = 64;
    public static final HWND HWND_TOP;
    public static final HWND HWND_TOPMOST;
    public static final HWND HWND_NOTOPMOST;
    public static final int IDI_APPLICATION = 32512;
    public static final int IDI_ASTERISK = 32516;
    public static final int IDI_ERROR = 32513;
    public static final int IDI_EXCLAMATION = 32515;
    public static final int IDI_HAND = 32513;
    public static final int IDI_INFORMATION = 32516;
    public static final int IDI_QUESTION = 32514;
    public static final int IDI_WARNING = 32515;
    public static final int IDI_WINLOGO = 32517;
    public static final int IDI_SHIELD = 32518;
    public static final int WM_HOTKEY = 786;
    public static final int GWL_WNDPROC = -4;
    public static final int MOD_ALT = 1;
    public static final int MOD_CONTROL = 2;
    public static final int MOD_SHIFT = 4;
    public static final int MOD_WIN = 8;

    static {
        HWND_TOP = new HWND(0);
        HWND_TOPMOST = new HWND(-1);
        HWND_NOTOPMOST = new HWND(-2);
    }

    public static HWND GetDesktopWindow() throws NativeException, IllegalAccessException {
        JNative GetDesktopWindow = new JNative(DLL_NAME, "GetDesktopWindow");
        try {
            GetDesktopWindow.setRetVal(Type.INT);
            GetDesktopWindow.invoke();
            HWND hWND = new HWND(GetDesktopWindow.getRetValAsInt());
            return hWND;
        }
        finally {
            if (GetDesktopWindow != null) {
                GetDesktopWindow.dispose();
            }
        }
    }

    public static boolean GetIconInfo(LONG hIcon, ICONINFO piconinfo) throws NativeException, IllegalAccessException {
        JNative GetIconInfo = new JNative(DLL_NAME, "GetIconInfo");
        try {
            GetIconInfo.setRetVal(Type.INT);
            GetIconInfo.setParameter(0, hIcon.getValue());
            GetIconInfo.setParameter(1, piconinfo.getPointer());
            GetIconInfo.invoke();
            boolean bl = GetIconInfo.getRetValAsInt() != 0;
            return bl;
        }
        finally {
            if (GetIconInfo != null) {
                GetIconInfo.dispose();
            }
        }
    }

    public static int ReleaseDC(HWND hwnd, DC hdc) throws NativeException, IllegalAccessException {
        JNative ReleaseDC = new JNative(DLL_NAME, "ReleaseDC");
        try {
            ReleaseDC.setRetVal(Type.INT);
            ReleaseDC.setParameter(0, (Integer)hwnd.getValue());
            ReleaseDC.setParameter(0, hdc.getValue());
            ReleaseDC.invoke();
            int n = ReleaseDC.getRetValAsInt();
            return n;
        }
        finally {
            if (ReleaseDC != null) {
                ReleaseDC.dispose();
            }
        }
    }

    public static DC GetDC(HWND hwnd) throws NativeException, IllegalAccessException {
        JNative GetDC = new JNative(DLL_NAME, "GetDC");
        try {
            GetDC.setRetVal(Type.INT);
            GetDC.setParameter(0, (Integer)hwnd.getValue());
            GetDC.invoke();
            DC dC = new DC(GetDC.getRetValAsInt());
            return dC;
        }
        finally {
            if (GetDC != null) {
                GetDC.dispose();
            }
        }
    }

    public static int GetWindowThreadProcessId(HWND hwnd) {
        if (hwnd == null) {
            return -1;
        }
        Pointer nBufferGWT = null;
        try {
            if (getProcessHandle == null) {
                getProcessHandle = new JNative(DLL_NAME, "GetWindowThreadProcessId");
                getProcessHandle.setRetVal(Type.INT);
            }
            nBufferGWT = new Pointer(MemoryBlockFactory.createMemoryBlock(4));
            getProcessHandle.setParameter(0, (Integer)hwnd.getValue());
            getProcessHandle.setParameter(1, nBufferGWT);
            getProcessHandle.invoke();
            int n = nBufferGWT.getAsInt(0);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (nBufferGWT != null) {
                    nBufferGWT.dispose();
                }
                nBufferGWT = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static HWND FindWindow(String className, String windowName) throws NativeException, IllegalAccessException {
        JNative _FindWindow = new JNative(DLL_NAME, "FindWindowA");
        try {
            _FindWindow.setRetVal(Type.INT);
            _FindWindow.setParameter(0, Type.STRING, className);
            _FindWindow.setParameter(1, Type.STRING, windowName);
            _FindWindow.invoke();
            int valRet = Integer.parseInt(_FindWindow.getRetVal());
            HWND hWND = new HWND(valRet);
            return hWND;
        }
        finally {
            if (_FindWindow != null) {
                _FindWindow.dispose();
            }
        }
    }

    public static LRESULT CallWindowProc(LONG lpPrevWndFunc, HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam) throws NativeException, IllegalAccessException {
        JNative dwp = new JNative(DLL_NAME, "CallWindowProcA");
        try {
            dwp.setRetVal(Type.INT);
            int i = 0;
            dwp.setParameter(i++, lpPrevWndFunc.getValue());
            dwp.setParameter(i++, (Integer)hwnd.getValue());
            dwp.setParameter(i++, msg.getValue().shortValue());
            dwp.setParameter(i++, wparam.getValue());
            dwp.setParameter(i++, lparam.getValue());
            dwp.invoke();
            LRESULT lRESULT = new LRESULT(dwp.getRetValAsInt());
            return lRESULT;
        }
        finally {
            if (dwp != null) {
                dwp.dispose();
            }
        }
    }

    public static LRESULT DefWindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam) throws NativeException, IllegalAccessException {
        JNative dwp = new JNative(DLL_NAME, "DefWindowProcA");
        dwp.setRetVal(Type.INT);
        dwp.setParameter(0, Type.INT, hwnd.getValueAsString());
        dwp.setParameter(1, Type.INT, msg.getValueAsString());
        dwp.setParameter(2, Type.INT, wparam.getValueAsString());
        dwp.setParameter(3, Type.INT, lparam.getValueAsString());
        dwp.invoke();
        return new LRESULT(dwp.getRetValAsInt());
    }

    public static void UpdateWindow(HWND hwnd) throws NativeException, IllegalAccessException {
        JNative dm = new JNative(DLL_NAME, "UpdateWindow");
        dm.setParameter(0, Type.INT, hwnd.getValueAsString());
        dm.invoke();
        dm.dispose();
    }

    public static void DispatchMessage(MSG msg) throws NativeException, IllegalAccessException {
        JNative dm = new JNative(DLL_NAME, "DispatchMessageA");
        dm.setParameter(0, msg.getValue());
        dm.invoke();
        dm.dispose();
    }

    public static void TranslateMessage(MSG msg) throws NativeException, IllegalAccessException {
        JNative dm = new JNative(DLL_NAME, "TranslateMessage");
        dm.setParameter(0, msg.getValue());
        dm.invoke();
        dm.dispose();
    }

    public static int PeekMessage(MSG msg, HWND hwnd, int minMSG, int maxMSG, int removeMsg) throws NativeException, IllegalAccessException {
        JNative gm = new JNative(DLL_NAME, "PeekMessageA");
        gm.setRetVal(Type.INT);
        gm.setParameter(0, msg.getValue());
        gm.setParameter(1, Type.INT, hwnd.getValueAsString());
        gm.setParameter(2, Type.INT, "" + minMSG);
        gm.setParameter(3, Type.INT, "" + maxMSG);
        gm.setParameter(4, Type.INT, "" + removeMsg);
        gm.invoke();
        int ret = gm.getRetValAsInt();
        gm.dispose();
        return ret;
    }

    public static int GetMessage(MSG msg, HWND hwnd, int minMSG, int maxMSG) throws NativeException, IllegalAccessException {
        JNative gm = new JNative(DLL_NAME, "GetMessageA");
        gm.setRetVal(Type.INT);
        gm.setParameter(0, msg.getValue());
        gm.setParameter(1, Type.INT, hwnd.getValueAsString());
        gm.setParameter(2, Type.INT, "" + minMSG);
        gm.setParameter(3, Type.INT, "" + maxMSG);
        gm.invoke();
        int ret = gm.getRetValAsInt();
        gm.dispose();
        return ret;
    }

    public static boolean ShowWindow(HWND hwnd, int nCmdShow) throws NativeException, IllegalAccessException {
        JNative w = null;
        try {
            w = new JNative(DLL_NAME, "ShowWindow");
            w.setRetVal(Type.INT);
            w.setParameter(0, Type.INT, hwnd.getValueAsString());
            w.setParameter(1, Type.INT, "" + nCmdShow);
            w.invoke();
            boolean bl = Integer.parseInt(w.getRetVal()) != 0;
            return bl;
        }
        finally {
            if (w != null) {
                w.dispose();
            }
        }
    }

    public static final int CreateWindowEx(int dwExStyle, String lpClassName, String lpWindowName, int dwStyle, int x, int y, int nWidth, int nHeight, int hWndParent, int hMenu, int hInstance, int lParam) throws NativeException, IllegalAccessException {
        JNative n = null;
        try {
            n = new JNative(DLL_NAME, "CreateWindowExA");
            n.setRetVal(Type.INT);
            int i = 0;
            n.setParameter(i++, Type.INT, "" + dwExStyle);
            n.setParameter(i++, Type.STRING, lpClassName);
            if (lpWindowName == null) {
                n.setParameter(i++, 0);
            } else {
                n.setParameter(i++, lpWindowName);
            }
            n.setParameter(i++, Type.INT, "" + dwStyle);
            n.setParameter(i++, Type.INT, "" + x);
            n.setParameter(i++, Type.INT, "" + y);
            n.setParameter(i++, Type.INT, "" + nWidth);
            n.setParameter(i++, Type.INT, "" + nHeight);
            n.setParameter(i++, Type.INT, "" + hWndParent);
            n.setParameter(i++, Type.INT, "" + hMenu);
            n.setParameter(i++, Type.INT, "" + (hInstance == 0 ? JNative.getCurrentModule() : hInstance));
            n.setParameter(i++, Type.INT, "" + lParam);
            n.invoke();
            int n2 = Integer.parseInt(n.getRetVal());
            return n2;
        }
        finally {
            if (n != null) {
                n.dispose();
            }
        }
    }

    public static final int CreateWindowEx(int dwExStyle, LONG lpClassName, String lpWindowName, int dwStyle, int x, int y, int nWidth, int nHeight, int hWndParent, int hMenu, int hInstance, int lParam) throws NativeException, IllegalAccessException {
        JNative n = null;
        try {
            n = new JNative(DLL_NAME, "CreateWindowExA");
            n.setRetVal(Type.INT);
            int i = 0;
            n.setParameter(i++, Type.INT, "" + dwExStyle);
            n.setParameter(i++, lpClassName.getValue());
            if (lpWindowName == null) {
                n.setParameter(i++, 0);
            } else {
                n.setParameter(i++, lpWindowName);
            }
            n.setParameter(i++, Type.INT, "" + dwStyle);
            n.setParameter(i++, Type.INT, "" + x);
            n.setParameter(i++, Type.INT, "" + y);
            n.setParameter(i++, Type.INT, "" + nWidth);
            n.setParameter(i++, Type.INT, "" + nHeight);
            n.setParameter(i++, Type.INT, "" + hWndParent);
            n.setParameter(i++, Type.INT, "" + hMenu);
            n.setParameter(i++, Type.INT, "" + (hInstance == 0 ? JNative.getCurrentModule() : hInstance));
            n.setParameter(i++, Type.INT, "" + lParam);
            n.invoke();
            int n2 = Integer.parseInt(n.getRetVal());
            return n2;
        }
        finally {
            if (n != null) {
                n.dispose();
            }
        }
    }

    public static final int MessageBox(int parentHandle, String message, String caption, int buttons) throws NativeException, IllegalAccessException {
        JNative n = null;
        try {
            n = new JNative(DLL_NAME, "MessageBoxA");
            n.setRetVal(Type.INT);
            int i = 0;
            n.setParameter(i++, Type.INT, "" + parentHandle);
            n.setParameter(i++, Type.STRING, message);
            n.setParameter(i++, Type.STRING, caption);
            n.setParameter(i++, Type.INT, "" + buttons);
            n.invoke();
            int n2 = Integer.parseInt(n.getRetVal());
            return n2;
        }
        finally {
            if (n != null) {
                n.dispose();
            }
        }
    }

    public static boolean EnumWindows(Callback lpEnumFunc, int lParam) throws NativeException, IllegalAccessException {
        if (nEnumWindows == null) {
            nEnumWindows = new JNative(DLL_NAME, "EnumWindows", false);
            nEnumWindows.setRetVal(Type.INT);
        }
        nEnumWindows.setParameter(0, lpEnumFunc.getCallbackAddress());
        nEnumWindows.setParameter(1, lParam);
        nEnumWindows.invoke();
        return !"0".equals(nEnumWindows.getRetVal());
    }

    public static String GetWindowText(HWND hwnd) throws NativeException, IllegalAccessException {
        if (nGetWindowText == null) {
            nGetWindowText = new JNative(DLL_NAME, "GetWindowTextA");
            nGetWindowText.setRetVal(Type.INT);
            nBufferGWT = new Pointer(MemoryBlockFactory.createMemoryBlock(512));
            nGetWindowText.setParameter(1, nBufferGWT);
            nGetWindowText.setParameter(2, nBufferGWT.getSize());
        }
        nGetWindowText.setParameter(0, (Integer)hwnd.getValue());
        nGetWindowText.invoke();
        if ("0".equals(nGetWindowText.getRetVal())) {
            return "";
        }
        return nBufferGWT.getAsString();
    }

    public static int SetWindowLong(HWND hwnd, int nIndex, LONG dwNewLong) throws NativeException, IllegalAccessException {
        JNative _setWindowLong = new JNative(DLL_NAME, "SetWindowLongA");
        _setWindowLong.setRetVal(Type.INT);
        _setWindowLong.setParameter(0, (Integer)hwnd.getValue());
        _setWindowLong.setParameter(1, nIndex);
        _setWindowLong.setParameter(2, dwNewLong.getValue());
        _setWindowLong.invoke();
        int ret = _setWindowLong.getRetValAsInt();
        _setWindowLong.dispose();
        return ret;
    }

    public static LONG RegisterClass(WNDCLASS lpWndClass) throws NativeException, IllegalAccessException {
        JNative registerClass = new JNative(DLL_NAME, "RegisterClassA");
        registerClass.setRetVal(Type.INT);
        registerClass.setParameter(0, lpWndClass.createPointer());
        registerClass.invoke();
        int i = registerClass.getRetValAsInt();
        registerClass.dispose();
        return new LONG(i);
    }

    public static LONG LoadIcon(LONG hInstance, String lpIconName) throws NativeException, IllegalAccessException {
        JNative loadIcon = new JNative(DLL_NAME, "LoadIconA");
        loadIcon.setRetVal(Type.INT);
        loadIcon.setParameter(0, hInstance.getValue());
        loadIcon.setParameter(1, lpIconName);
        loadIcon.invoke();
        int ret = loadIcon.getRetValAsInt();
        loadIcon.dispose();
        return new LONG(ret);
    }

    public static LONG LoadIcon(LONG hInstance, int ressource) throws NativeException, IllegalAccessException {
        JNative loadIcon = new JNative(DLL_NAME, "LoadIconA");
        loadIcon.setRetVal(Type.INT);
        loadIcon.setParameter(0, hInstance.getValue());
        loadIcon.setParameter(1, ressource);
        loadIcon.invoke();
        int ret = loadIcon.getRetValAsInt();
        loadIcon.dispose();
        return new LONG(ret);
    }

    public static LRESULT SendMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam) throws NativeException, IllegalAccessException {
        JNative SendMessage = new JNative(DLL_NAME, "SendMessageA");
        SendMessage.setRetVal(Type.INT);
        int pos = 0;
        SendMessage.setParameter(pos++, (Integer)hWnd.getValue());
        SendMessage.setParameter(pos++, Msg.getValue().shortValue());
        SendMessage.setParameter(pos++, wParam.getValue());
        SendMessage.setParameter(pos++, lParam.getValue());
        SendMessage.invoke();
        pos = SendMessage.getRetValAsInt();
        SendMessage.dispose();
        return new LRESULT(pos);
    }

    public static int[] grabImage(ImageIcon icon) throws InterruptedException {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, pixels, 0, w);
        pg.grabPixels();
        if ((pg.getStatus() & 0x80) != 0) {
            return null;
        }
        return pixels;
    }

    public static LONG CreateIcon(LONG hInstance, int cPlanes, int cBitsPixel, ImageIcon icon) throws InterruptedException, NativeException, IllegalAccessException {
        if (icon == null) {
            return new LONG(0);
        }
        int[] pixels = User32.grabImage(icon);
        if (pixels == null) {
            return new LONG(0);
        }
        return User32.CreateIcon(hInstance, icon.getIconWidth(), icon.getIconHeight(), cPlanes, cBitsPixel, pixels, pixels);
    }

    public static LONG CreateIcon(LONG hInstance, int nWidth, int nHeight, int cPlanes, int cBitsPixel, int[] lpbANDbits, int[] lpbXORbits) throws NativeException, IllegalAccessException {
        JNative createIcon = new JNative(DLL_NAME, "CreateIcon");
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(lpbXORbits.length * 4));
        int i = 0;
        while (i < lpbXORbits.length) {
            p.setIntAt(i * 4, lpbXORbits[i]);
            ++i;
        }
        createIcon.setRetVal(Type.INT);
        i = 0;
        createIcon.setParameter(i++, hInstance.getValue());
        createIcon.setParameter(i++, nWidth);
        createIcon.setParameter(i++, nHeight);
        createIcon.setParameter(i++, cPlanes);
        createIcon.setParameter(i++, cBitsPixel);
        createIcon.setParameter(i++, p);
        createIcon.setParameter(i++, p);
        createIcon.invoke();
        i = createIcon.getRetValAsInt();
        createIcon.dispose();
        return new LONG(i);
    }

    public static LONG GetWindowLong(HWND hWnd, int nIndex) throws NativeException, IllegalAccessException {
        JNative GetWindowLong = new JNative(DLL_NAME, "GetWindowLongA");
        GetWindowLong.setRetVal(Type.INT);
        int pos = 0;
        GetWindowLong.setParameter(pos++, (Integer)hWnd.getValue());
        GetWindowLong.setParameter(pos++, nIndex);
        GetWindowLong.invoke();
        pos = GetWindowLong.getRetValAsInt();
        GetWindowLong.dispose();
        return new LONG(pos);
    }

    public static boolean AttachThreadInput(int idAttach, int idAttachTo, boolean fAttach) throws NativeException, IllegalAccessException {
        JNative AttachThreadInput = new JNative(DLL_NAME, "AttachThreadInput");
        AttachThreadInput.setRetVal(Type.INT);
        int pos = 0;
        AttachThreadInput.setParameter(pos++, idAttach);
        AttachThreadInput.setParameter(pos++, idAttachTo);
        AttachThreadInput.setParameter(pos++, fAttach ? "1" : "0");
        AttachThreadInput.invoke();
        pos = AttachThreadInput.getRetValAsInt();
        AttachThreadInput.dispose();
        return pos != 0;
    }

    public static HWND GetForegroundWindow() throws NativeException, IllegalAccessException {
        JNative GetForegroundWindow = new JNative(DLL_NAME, "GetForegroundWindow");
        GetForegroundWindow.setRetVal(Type.INT);
        GetForegroundWindow.invoke();
        int ret = GetForegroundWindow.getRetValAsInt();
        GetForegroundWindow.dispose();
        return new HWND(ret);
    }

    public static HWND SetActiveWindow(HWND hWnd) throws NativeException, IllegalAccessException {
        JNative SetActiveWindow = new JNative(DLL_NAME, "SetActiveWindow");
        SetActiveWindow.setRetVal(Type.INT);
        int pos = 0;
        SetActiveWindow.setParameter(pos++, (Integer)hWnd.getValue());
        SetActiveWindow.invoke();
        pos = SetActiveWindow.getRetValAsInt();
        SetActiveWindow.dispose();
        return new HWND(pos);
    }

    public static boolean SetForegroundWindow(HWND hWnd) throws NativeException, IllegalAccessException {
        JNative SetForegroundWindow = new JNative(DLL_NAME, "SetForegroundWindow");
        SetForegroundWindow.setRetVal(Type.INT);
        int pos = 0;
        SetForegroundWindow.setParameter(pos++, (Integer)hWnd.getValue());
        SetForegroundWindow.invoke();
        pos = SetForegroundWindow.getRetValAsInt();
        SetForegroundWindow.dispose();
        return pos != 0;
    }

    public static boolean SetForegroundWindowEx(HWND hWnd) throws NativeException, IllegalAccessException {
        int lThreadForeWin;
        int lThreadWindow = User32.GetWindowThreadProcessId(hWnd);
        if (lThreadWindow == (lThreadForeWin = User32.GetWindowThreadProcessId(User32.GetForegroundWindow()))) {
            return User32.SetForegroundWindow(hWnd);
        }
        User32.AttachThreadInput(lThreadForeWin, lThreadWindow, true);
        boolean b = User32.SetForegroundWindow(hWnd);
        User32.AttachThreadInput(lThreadForeWin, lThreadWindow, false);
        return b;
    }

    public static boolean DestroyIcon(LONG hIcon) throws NativeException, IllegalAccessException {
        JNative DestroyIcon = new JNative(DLL_NAME, "DestroyIcon");
        DestroyIcon.setRetVal(Type.INT);
        int pos = 0;
        DestroyIcon.setParameter(pos++, hIcon.getValue());
        DestroyIcon.invoke();
        pos = DestroyIcon.getRetValAsInt();
        DestroyIcon.dispose();
        return pos != 0;
    }

    public static int RegisterWindowMessage(String lpString) throws NativeException, IllegalAccessException {
        JNative RegisterWindowMessage = new JNative(DLL_NAME, "RegisterWindowMessageA");
        RegisterWindowMessage.setRetVal(Type.INT);
        int pos = 0;
        RegisterWindowMessage.setParameter(pos++, lpString);
        RegisterWindowMessage.invoke();
        pos = RegisterWindowMessage.getRetValAsInt();
        RegisterWindowMessage.dispose();
        return pos;
    }

    public static boolean SetWindowPos(HWND hWnd, HWND hWndInsertAfter, int X, int Y, int cx, int cy, int uFlags) throws NativeException, IllegalAccessException {
        JNative SetWindowPos = new JNative(DLL_NAME, "SetWindowPos");
        SetWindowPos.setRetVal(Type.INT);
        int pos = 0;
        SetWindowPos.setParameter(pos++, (Integer)hWnd.getValue());
        SetWindowPos.setParameter(pos++, (Integer)hWndInsertAfter.getValue());
        SetWindowPos.setParameter(pos++, X);
        SetWindowPos.setParameter(pos++, Y);
        SetWindowPos.setParameter(pos++, cx);
        SetWindowPos.setParameter(pos++, cy);
        SetWindowPos.setParameter(pos++, uFlags);
        SetWindowPos.invoke();
        pos = SetWindowPos.getRetValAsInt();
        SetWindowPos.dispose();
        return pos != 0;
    }

    public static boolean setOnTop(HWND hWnd) {
        try {
            return User32.SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, 3);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return false;
        }
    }

    public static boolean RegisterHotKey(HWND hWnd, int id, int fsModifiers, int vk) throws NativeException, IllegalAccessException {
        JNative RegisterHotKey = new JNative(DLL_NAME, "RegisterHotKey");
        RegisterHotKey.setRetVal(Type.INT);
        int pos = 0;
        RegisterHotKey.setParameter(pos++, (Integer)hWnd.getValue());
        RegisterHotKey.setParameter(pos++, id);
        RegisterHotKey.setParameter(pos++, fsModifiers);
        RegisterHotKey.setParameter(pos++, vk);
        RegisterHotKey.invoke();
        pos = RegisterHotKey.getRetValAsInt();
        RegisterHotKey.dispose();
        return pos != 0;
    }

    public static boolean UnregisterHotKey(String lpString) throws NativeException, IllegalAccessException {
        JNative UnregisterHotKey = new JNative(DLL_NAME, "UnregisterHotKey");
        UnregisterHotKey.setRetVal(Type.INT);
        int pos = 0;
        UnregisterHotKey.setParameter(pos++, lpString);
        UnregisterHotKey.invoke();
        pos = UnregisterHotKey.getRetValAsInt();
        UnregisterHotKey.dispose();
        return pos != 0;
    }
}

