/*
 * Decompiled with CFR 0.152.
 */
package org.pgusb.usbDllAdapter;

import org.pgusb.usbDllAdapter.ReadBytes;
import org.pgusb.usbDllAdapter.WriteBytes;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.HeapMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class UsbDllAdapter {
    public static final String DLL_NAME = "mpusbapi.dll";
    private static JNative f_MPUSBGetDLLVersion;
    private static JNative f_MPUSBGetDeviceCount;
    private static JNative f_MPUSBOpen;
    private static JNative f_MPUSBRead;
    private static JNative f_MPUSBWrite;
    private static JNative f_MPUSBReadInt;
    private static JNative f_MPUSBClose;

    public static int MPUSBGetDLLVersion() throws NativeException, IllegalAccessException {
        if (f_MPUSBGetDLLVersion == null) {
            f_MPUSBGetDLLVersion = new JNative(DLL_NAME, "MPUSBGetDLLVersion");
            f_MPUSBGetDLLVersion.setRetVal(Type.LONG);
        }
        f_MPUSBGetDLLVersion.invoke();
        return new Integer(f_MPUSBGetDLLVersion.getRetVal());
    }

    public static int MPUSBGetDeviceCount(String vid_pid) throws NativeException, IllegalAccessException {
        if (f_MPUSBGetDeviceCount == null) {
            f_MPUSBGetDeviceCount = new JNative(DLL_NAME, "MPUSBGetDeviceCount");
            f_MPUSBGetDeviceCount.setRetVal(Type.LONG);
        }
        Pointer p_vid_pid = new Pointer(MemoryBlockFactory.createMemoryBlock((int)(vid_pid.length() + 1)));
        p_vid_pid.setStringAt(0, vid_pid);
        f_MPUSBGetDeviceCount.setParameter(0, p_vid_pid);
        f_MPUSBGetDeviceCount.invoke();
        int ret = new Integer(f_MPUSBGetDeviceCount.getRetVal());
        p_vid_pid.dispose();
        return ret;
    }

    public static int MPUSBOpen(int instance, String vid_pid, String ep, int dir, int reserved) throws NativeException, IllegalAccessException {
        Pointer p_vid_pid = new Pointer(MemoryBlockFactory.createMemoryBlock((int)(vid_pid.length() + 1)));
        p_vid_pid.setStringAt(0, vid_pid);
        if (f_MPUSBOpen == null) {
            f_MPUSBOpen = new JNative(DLL_NAME, "MPUSBOpen");
            f_MPUSBOpen.setRetVal(Type.INT);
        }
        f_MPUSBOpen.setParameter(0, Type.INT, "" + instance);
        f_MPUSBOpen.setParameter(1, p_vid_pid);
        Pointer p_EP = null;
        if (ep != null) {
            p_EP = new Pointer(MemoryBlockFactory.createMemoryBlock((int)(ep.length() + 1)));
            p_EP.setStringAt(0, ep);
            f_MPUSBOpen.setParameter(2, p_EP);
        } else {
            f_MPUSBOpen.setParameter(2, NullPointer.NULL);
        }
        f_MPUSBOpen.setParameter(3, Type.INT, "" + dir);
        f_MPUSBOpen.setParameter(4, Type.INT, "" + reserved);
        f_MPUSBOpen.invoke();
        int ret = Integer.parseInt(f_MPUSBOpen.getRetVal());
        p_EP.dispose();
        return ret;
    }

    public static ReadBytes MPUSBRead(int handle, int len, int milliseconds) throws NativeException, IllegalAccessException {
        Pointer pData = new Pointer((MemoryBlock)new HeapMemoryBlock(len));
        LONG pLength = new LONG(40);
        if (f_MPUSBRead == null) {
            f_MPUSBRead = new JNative(DLL_NAME, "MPUSBRead");
            f_MPUSBRead.setRetVal(Type.INT);
        }
        f_MPUSBRead.setParameter(0, Type.INT, "" + handle);
        f_MPUSBRead.setParameter(1, pData);
        f_MPUSBRead.setParameter(2, Type.INT, "" + len);
        f_MPUSBRead.setParameter(3, pLength.createPointer());
        f_MPUSBRead.setParameter(4, Type.INT, "" + milliseconds);
        f_MPUSBRead.invoke();
        byte[] readBytes = pData.getMemory();
        pData.dispose();
        ReadBytes ret = new ReadBytes(readBytes, pLength.getValue(), Integer.parseInt(f_MPUSBRead.getRetVal()));
        return ret;
    }

    public static WriteBytes MPUSBWrite(int handle, byte[] data, int len, int milliseconds) throws NativeException, IllegalAccessException {
        Pointer pData = new Pointer(MemoryBlockFactory.createMemoryBlock((int)len));
        pData.setMemory(data);
        LONG pLength = new LONG(0);
        if (f_MPUSBWrite == null) {
            f_MPUSBWrite = new JNative(DLL_NAME, "MPUSBWrite");
            f_MPUSBWrite.setRetVal(Type.INT);
        }
        f_MPUSBWrite.setParameter(0, Type.INT, "" + handle);
        f_MPUSBWrite.setParameter(1, pData);
        f_MPUSBWrite.setParameter(2, Type.INT, "" + len);
        f_MPUSBWrite.setParameter(3, pLength.createPointer());
        f_MPUSBWrite.setParameter(4, Type.INT, "" + milliseconds);
        f_MPUSBWrite.invoke();
        WriteBytes ret = new WriteBytes(pLength.getValue(), Integer.parseInt(f_MPUSBWrite.getRetVal()));
        pData.dispose();
        return ret;
    }

    public static ReadBytes MPUSBReadInt(int handle, int len, int milliseconds) throws NativeException, IllegalAccessException {
        Pointer pData = new Pointer((MemoryBlock)new HeapMemoryBlock(len));
        LONG pLength = new LONG(40);
        if (f_MPUSBReadInt == null) {
            f_MPUSBReadInt = new JNative(DLL_NAME, "MPUSBReadInt");
            f_MPUSBReadInt.setRetVal(Type.INT);
        }
        f_MPUSBReadInt.setParameter(0, Type.INT, "" + handle);
        f_MPUSBReadInt.setParameter(1, pData);
        f_MPUSBReadInt.setParameter(2, Type.INT, "" + len);
        f_MPUSBReadInt.setParameter(3, pLength.createPointer());
        f_MPUSBReadInt.setParameter(4, Type.INT, "" + milliseconds);
        f_MPUSBReadInt.invoke();
        byte[] readBytes = pData.getMemory();
        pData.dispose();
        ReadBytes ret = new ReadBytes(readBytes, pLength.getValue(), Integer.parseInt(f_MPUSBReadInt.getRetVal()));
        return ret;
    }

    public static int MPUSBClose(int handle) throws NativeException, IllegalAccessException {
        if (f_MPUSBClose == null) {
            f_MPUSBClose = new JNative(DLL_NAME, "MPUSBClose");
            f_MPUSBClose.setRetVal(Type.LONG);
        }
        f_MPUSBClose.setParameter(0, Type.INT, "" + handle);
        f_MPUSBClose.invoke();
        return new Integer(f_MPUSBClose.getRetVal());
    }
}

