/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point
extends AbstractBasicData<Point> {
    protected int x;
    protected int y;

    public Point() {
        this(0, 0);
    }

    public Point(int x, int y) {
        super(null);
        this.x = x;
        this.y = y;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(Point.sizeOf()));
        this.pointer.setIntAt(0, this.x);
        this.pointer.setIntAt(4, this.y);
        return this.pointer;
    }

    @Override
    public Point getValueFromPointer() throws NativeException {
        this.x = this.pointer.getAsInt(0);
        this.y = this.pointer.getAsInt(4);
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public Point getValue() {
        return this;
    }

    @Override
    public int getSizeOf() {
        return Point.sizeOf();
    }

    public static int sizeOf() {
        return 16;
    }
}

