/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.pointers.memory;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.pointers.memory.AbstractMemoryBlock;

public class GlobalMemoryBlock
extends AbstractMemoryBlock {
    public static final int GMEM_FIXED = 0;
    public static final int GMEM_ZEROINIT = 64;
    public static final int GPTR = 64;
    public static final int GMEM_MOVEABLE = 2;
    public static final int GHND = 66;
    static final JNative globalAlloc;
    static final JNative globalFree;
    private int type;

    static {
        try {
            globalAlloc = new JNative("Kernel32.dll", "GlobalAlloc");
            globalAlloc.setRetVal(Type.INT);
            globalFree = new JNative("Kernel32.dll", "GlobalFree");
            globalFree.setRetVal(Type.INT);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public GlobalMemoryBlock(int size) throws NativeException {
        this(size, 64);
    }

    public GlobalMemoryBlock(int size, int type) throws NativeException {
        super(size);
        this.type = type;
        this.reserveMemory(size);
    }

    public int reserveMemory(int size) throws NativeException {
        this.setSize(size);
        if (this.getPointer() != null) {
            this.dispose();
        }
        try {
            globalAlloc.setParameter(0, Type.INT, "" + this.type);
            globalAlloc.setParameter(1, Type.INT, "" + size);
            globalAlloc.invoke();
            this.setPointer(Integer.parseInt(globalAlloc.getRetVal()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        return this.getPointer();
    }

    public void dispose() throws NativeException {
        if (this.getPointer() != null) {
            try {
                globalFree.setParameter(0, Type.INT, this.getPointer().toString());
                globalFree.invoke();
                if (Integer.parseInt(globalFree.getRetVal()) != 0) {
                    throw new NativeException("Memory not freed !");
                }
                this.setPointer(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

