/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class PsAPI {
    public static final String DLL_NAME = "PSAPI.DLL";
    private static JNative nEnumProcess;
    private static Pointer nReadProcess;
    private static JNative nEnumProcessModules;
    private static LONG lpcbNeeded;
    private static JNative nGetModuleBaseName;

    public static int[] EnumProcess(int maxSizeOfInitialBuffer) throws NativeException, IllegalAccessException {
        if (maxSizeOfInitialBuffer < 4) {
            maxSizeOfInitialBuffer = 4;
        }
        if (nEnumProcess == null) {
            nEnumProcess = new JNative(DLL_NAME, "EnumProcesses");
            nEnumProcess.setRetVal(Type.INT);
            nReadProcess = new Pointer(MemoryBlockFactory.createMemoryBlock(4));
            nEnumProcess.setParameter(2, nReadProcess);
        }
        Pointer pProcessIds = new Pointer(MemoryBlockFactory.createMemoryBlock(maxSizeOfInitialBuffer));
        nEnumProcess.setParameter(0, pProcessIds);
        nEnumProcess.setParameter(1, Type.INT, String.valueOf(maxSizeOfInitialBuffer));
        nEnumProcess.invoke();
        if ("0".equals(nEnumProcess.getRetVal())) {
            return null;
        }
        int sizeNeeded = nReadProcess.getAsInt(0);
        if (sizeNeeded > maxSizeOfInitialBuffer) {
            System.err.println(String.valueOf(maxSizeOfInitialBuffer) + " is to low, will recall with " + sizeNeeded);
            return PsAPI.EnumProcess(sizeNeeded);
        }
        int numProcess = nReadProcess.getAsInt(0) / 4;
        int[] process = new int[numProcess];
        int i = 0;
        while (i < numProcess) {
            process[i] = pProcessIds.getAsInt(i * 4);
            ++i;
        }
        pProcessIds.dispose();
        return process;
    }

    public static Pointer EnumProcessModules(HANDLE hProcessHandle, int maxSizeOfInitialBuffer) throws NativeException, IllegalAccessException {
        if (maxSizeOfInitialBuffer < 4) {
            maxSizeOfInitialBuffer = 4;
        }
        if (nEnumProcessModules == null) {
            nEnumProcessModules = new JNative(DLL_NAME, "EnumProcessModules");
            nEnumProcessModules.setRetVal(Type.INT);
            lpcbNeeded = new LONG(0);
            nEnumProcessModules.setParameter(3, lpcbNeeded.createPointer());
        }
        Pointer lphModule = new Pointer(MemoryBlockFactory.createMemoryBlock(maxSizeOfInitialBuffer));
        nEnumProcessModules.setParameter(0, hProcessHandle.getValue());
        nEnumProcessModules.setParameter(1, lphModule);
        nEnumProcessModules.setParameter(2, maxSizeOfInitialBuffer);
        nEnumProcessModules.invoke();
        int sizeNeeded = lpcbNeeded.getValueFromPointer();
        if ("0".equals(nEnumProcess.getRetVal())) {
            lphModule.dispose();
            return new NullPointer();
        }
        if (sizeNeeded > maxSizeOfInitialBuffer) {
            lphModule.dispose();
            System.err.println(String.valueOf(maxSizeOfInitialBuffer) + " is to low, will recall with " + sizeNeeded);
            return PsAPI.EnumProcessModules(hProcessHandle, sizeNeeded);
        }
        return lphModule;
    }

    public static String GetModuleBaseName(HANDLE hProcessHandle, int hModule, int nSize) throws NativeException, IllegalAccessException {
        if (nGetModuleBaseName == null) {
            nGetModuleBaseName = new JNative(DLL_NAME, "GetModuleBaseNameA");
            nGetModuleBaseName.setRetVal(Type.INT);
        }
        Pointer lpBaseName = new Pointer(MemoryBlockFactory.createMemoryBlock(nSize + 1));
        nGetModuleBaseName.setParameter(0, hProcessHandle.getValue());
        nGetModuleBaseName.setParameter(1, hModule);
        nGetModuleBaseName.setParameter(2, lpBaseName);
        nGetModuleBaseName.setParameter(3, nSize);
        nGetModuleBaseName.invoke();
        String ret = null;
        if (!"0".equals(nGetModuleBaseName.getRetVal())) {
            ret = lpBaseName.getAsString();
        }
        lpBaseName.dispose();
        return ret;
    }
}

