/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.test;

import java.io.File;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.GlobalMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.StructConverter;

public class SNDPTester {
    public static final int INIT_SUCCESS = 0;
    public static final int INIT_VERSION_ERROR = 1;
    public static final int INIT_SOCKET_FAILURE = 2;
    public static final int INIT_INI_NOT_FOUND = 3;
    public static final int INIT_MANAGER_START_FAILURE = 4;
    public static final int INIT_HEARTBEAT_FAILURE = 6;
    public static final int INIT_INVALID_PORTNUMBER = 11;
    public static final int INIT_SHUTTDOWN_IN_PROGRESS = 12;
    public static final int INIT_ALREADY_INITIALIZED = 13;
    public static final int SNDP_DISCONNECTED = 0;
    public static final int SNDP_EXCEPTION = 1;
    public static final int SNDP_NOT_INITIALIZED = 2;
    public static final int SNDP_APP_ERROR = 3;
    public static final int SNDP_INVALID_DOC_ID = 4;
    public static final int SNDP_DLL_ERROR = 5;
    public static final int SNDP_CONNECTED = 6;
    public static final int SNDP_READYING = 7;
    public static final int SNDP_READY = 8;
    public static final int SNDP_FLOWING = 9;
    public static final int SNDP_FEEDER_EMPTY = 10;
    public static final int SNDP_SHUTTING_DOWN = 11;
    public static final int SNDP_SHUTDOWN = 12;
    public static final int SNDP_CODELINES_AVAILABLE = 13;
    public static final int SNDP_FRONT_IMAGES_AVAILABLE = 14;
    public static final int SNDP_REAR_IMAGES_AVAILABLE = 15;
    public static final int SNDP_DOC_COMPLETE_AVAILABLE = 16;
    private static String cmc7;
    static JNative getCodeLines;
    static Pointer lpCodeLines;
    static LONG docId;
    static JNative getFrontImages;
    static Pointer lpFrontImageStruct;
    static JNative getRearImages;
    static Pointer lpRearImageStruct;
    static JNative getDocComplete;
    static UINT docStatus;
    static JNative setPocketAndEndorsement;
    static Pointer lpPocketStruct;
    static Pointer lpExceptionStruct;
    static JNative getUnitStatus;

    public static void main(String[] args) throws NativeException, IllegalAccessException, InterruptedException, NoSuchMethodException {
        MemoryBlockFactory.setPreferredMemoryType(GlobalMemoryBlock.class);
        SNDPTester.getUnitStatus();
        SNDPTester.shutDown();
        while (SNDPTester.getUnitStatus() != 2) {
            Thread.sleep(1L);
        }
        JNative initialize = new JNative("SNDP.dll", "Initialize");
        initialize.setRetVal(Type.INT);
        initialize.setParameter(0, Type.STRING, "C:\\SourceNDP\\Samples\\QualApp\\SNDP_DLL.INI");
        initialize.setParameter(1, Type.STRING, "C:\\SourceNDP");
        initialize.invoke();
        switch (Integer.parseInt(initialize.getRetVal())) {
            case 0: {
                System.err.println("Succes");
                SNDPTester.handleEvents();
                break;
            }
            case 1: {
                System.err.println("Version Error");
                break;
            }
            case 2: {
                System.err.println("Socket Error");
                break;
            }
            case 3: {
                System.err.println("INI not found");
                break;
            }
            case 4: {
                System.err.println("Manager Error");
                break;
            }
            case 6: {
                System.err.println("Heartbeat Error");
                break;
            }
            case 11: {
                System.err.println("Invalid port number");
                break;
            }
            case 12: {
                System.err.println("Shutdown in progress");
                break;
            }
            case 13: {
                System.err.println("Already initialized");
            }
        }
    }

    private static void handleEvents() throws NativeException, NumberFormatException, IllegalAccessException, InterruptedException {
        new File("Images").mkdirs();
        while (true) {
            SNDPTester.getUnitStatus();
        }
    }

    private static String getCodeLines() throws NativeException, IllegalAccessException {
        boolean ret;
        if (getCodeLines == null) {
            lpCodeLines = new Pointer(MemoryBlockFactory.createMemoryBlock(304));
            docId = new LONG(0);
            docId.createPointer();
            getCodeLines = new JNative("SNDP.DLL", "GetCodelines");
            getCodeLines.setRetVal(Type.INT);
        }
        getCodeLines.setParameter(0, lpCodeLines);
        getCodeLines.setParameter(1, docId.getPointer());
        getCodeLines.invoke();
        boolean bl = ret = !getCodeLines.getRetVal().equals("0");
        if (ret) {
            docId.getValueFromPointer();
            return new String(lpCodeLines.getMemory(), 10, 96);
        }
        throw new RuntimeException("GetCodeLines failed !");
    }

    private static byte[] getFrontImages() throws NativeException, IllegalAccessException {
        boolean ret;
        if (getFrontImages == null) {
            lpFrontImageStruct = new Pointer(MemoryBlockFactory.createMemoryBlock(44));
            getFrontImages = new JNative("SNDP.DLL", "GetFrontImages");
            getFrontImages.setRetVal(Type.INT);
            getFrontImages.setParameter(0, lpFrontImageStruct);
        }
        getFrontImages.setParameter(1, Type.INT, docId.toString());
        getFrontImages.invoke();
        System.err.println("fontimages done");
        String retS = getFrontImages.getRetVal();
        boolean bl = ret = !retS.equals("0");
        if (ret) {
            return JNative.getMemory(lpFrontImageStruct.getAsInt(4), lpFrontImageStruct.getAsInt(8));
        }
        System.err.println(String.valueOf(ret) + "<-" + retS);
        throw new RuntimeException("GetFrontImages failed !");
    }

    private static byte[] getRearImages() throws NativeException, IllegalAccessException {
        boolean ret;
        if (getRearImages == null) {
            lpRearImageStruct = new Pointer(MemoryBlockFactory.createMemoryBlock(20));
            getRearImages = new JNative("SNDP.DLL", "GetRearImages");
            getRearImages.setRetVal(Type.INT);
            getRearImages.setParameter(0, lpRearImageStruct);
        }
        getRearImages.setParameter(1, Type.INT, docId.toString());
        getRearImages.invoke();
        boolean bl = ret = !getRearImages.getRetVal().equals("0");
        if (ret) {
            return JNative.getMemory(lpRearImageStruct.getAsInt(4), lpRearImageStruct.getAsInt(8));
        }
        throw new RuntimeException("GetRearImages failed !");
    }

    private static int getDocComplete() throws NativeException, IllegalAccessException {
        boolean ret;
        if (getDocComplete == null) {
            docStatus = new UINT(2);
            getDocComplete = new JNative("SNDP.DLL", "GetDocComplete");
            getDocComplete.setRetVal(Type.INT);
            getDocComplete.setParameter(0, docStatus.createPointer());
        }
        getDocComplete.setParameter(1, Type.INT, docId.toString());
        getDocComplete.invoke();
        boolean bl = ret = !getDocComplete.getRetVal().equals("0");
        if (ret) {
            return docStatus.getValueFromPointer().shortValue();
        }
        throw new RuntimeException("GetDocComplete failed !");
    }

    private static void setPocketAndEndorsement() throws NativeException, IllegalAccessException {
        boolean ret;
        if (setPocketAndEndorsement == null) {
            lpPocketStruct = new Pointer(MemoryBlockFactory.createMemoryBlock(114));
            lpPocketStruct.zeroMemory();
            int offset = 0;
            offset += lpPocketStruct.setIntAt(offset, 1);
            offset += lpPocketStruct.setIntAt(offset, 1);
            offset += lpPocketStruct.setIntAt(offset, 1);
            setPocketAndEndorsement = new JNative("SNDP.DLL", "SetPocketAndEndorsement");
            setPocketAndEndorsement.setRetVal(Type.INT);
        }
        if (cmc7.length() < 8) {
            cmc7 = "<1234567<";
        }
        int lPocket = (cmc7.charAt(7) & '\u0001') + 1;
        String endo = "Poche " + lPocket;
        lpPocketStruct.setIntAt(12, endo.length());
        lpPocketStruct.setStringAt(16, endo);
        lpPocketStruct.setIntAt(108, lPocket);
        setPocketAndEndorsement.setParameter(0, lpPocketStruct);
        setPocketAndEndorsement.setParameter(1, Type.INT, docId.toString());
        setPocketAndEndorsement.invoke();
        boolean bl = ret = !setPocketAndEndorsement.getRetVal().equals("0");
        if (!ret) {
            throw new RuntimeException("SetPocketAndEndorsement failed !");
        }
    }

    private static int tireUnePiece() {
        return Math.random() > 0.5 ? 1 : 2;
    }

    private static String tireUnePieceAsString() {
        return Math.random() > 0.5 ? "Face" : "Pile";
    }

    private static boolean startFlow() throws NativeException, IllegalAccessException {
        JNative startFlow = new JNative("SNDP.DLL", "StartFlow");
        startFlow.setRetVal(Type.INT);
        startFlow.setParameter(0, Type.INT, "0");
        startFlow.invoke();
        boolean ret = !startFlow.getRetVal().equals("0");
        startFlow.dispose();
        System.err.println("StartFlow : " + ret);
        return ret;
    }

    public static int getUnitStatus() throws NativeException, NumberFormatException, IllegalAccessException {
        if (lpExceptionStruct == null) {
            lpExceptionStruct = new Pointer(MemoryBlockFactory.createMemoryBlock(21));
        }
        if (getUnitStatus == null) {
            getUnitStatus = new JNative("SNDP.DLL", "GetUnitStatus");
            getUnitStatus.setRetVal(Type.INT);
            getUnitStatus.setParameter(0, lpExceptionStruct);
        }
        getUnitStatus.invoke();
        return Integer.parseInt(getUnitStatus.getRetVal());
    }

    public static void shutDown() throws NativeException, IllegalAccessException {
        JNative shutdown = new JNative("SNDP.DLL", "ShutDown");
        shutdown.invoke();
        shutdown.dispose();
    }

    public static int loadDDValueFromNVM() {
        byte[] buffer = SNDPTester.getNVMData(4);
        if (buffer == null) {
            try {
                throw new RuntimeException("Impossible de lire la valeur de la NVRAM");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return 0;
            }
        }
        return StructConverter.bytesIntoInt(buffer, 0);
    }

    private static void saveDDValueNVM(double lDDocReference) {
        int val = (int)lDDocReference + 1;
        byte[] buf = new byte[4];
        StructConverter.intIntoBytes(val, buf, 0);
        if (!SNDPTester.setNVMData(buf)) {
            throw new RuntimeException("Impossible de sauver la valeur dans la NVRAM");
        }
    }

    public static byte[] getNVMData(int len) {
        Pointer data;
        block3: {
            try {
                JNative getNVMData = new JNative("SNDP.dll", "?GetNVMData@@YGHPAEK@Z");
                data = new Pointer(MemoryBlockFactory.createMemoryBlock(len));
                getNVMData.setRetVal(Type.INT);
                getNVMData.setParameter(0, data);
                getNVMData.setParameter(1, Type.INT, String.valueOf(data.getSize()));
                getNVMData.invoke();
                if (!"0".equals(getNVMData.getRetVal())) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return data.getMemory();
    }

    public static boolean setNVMData(byte[] buffer) {
        try {
            JNative setNVMData = new JNative("SNDP.dll", "?SetNVMData@@YGHPAEK@Z");
            Pointer data = new Pointer(MemoryBlockFactory.createMemoryBlock(buffer.length));
            data.setMemory(buffer);
            setNVMData.setRetVal(Type.INT);
            setNVMData.setParameter(0, data);
            setNVMData.setParameter(1, Type.INT, String.valueOf(buffer.length));
            setNVMData.invoke();
            String ret = setNVMData.getRetVal();
            System.err.println(ret);
            return !"0".equals(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

