/*
 * Decompiled with CFR 0.152.
 */
package org.pgusb.usb4allAPIWrapper;

import org.pgusb.usb4allAPIWrapper.ReadBytes;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.HeapMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class Usb4allAPIWrapper {
    public static String DLL_NAME = "libUsb4AllAPI.so";
    private static boolean inicialized = false;
    public static final int NULL_IN = 0;
    public static final int BULK_IN = 1;
    public static final int CTRL_IN = 2;
    public static final int INT_IN = 3;
    public static final int ISO_IN = 4;
    public static final int NULL_OUT = 5;
    public static final int BULK_OUT = 6;
    public static final int CTRL_OUT = 7;
    public static final int INT_OUT = 8;
    public static final int ISO_OUT = 9;
    public static final int MAX_PACKET_SIZE = 255;
    private static JNative f_openDevice;
    private static JNative f_configDevice;
    private static JNative f_sendData;
    private static JNative f_receiveData;
    private static JNative f_closeDevice;
    private static JNative f_apiVersion;
    private static JNative f_firmwareVersion;
    private static JNative f_getU4ABoards;
    private static JNative f_getSerialNumber;

    public static void init() {
        if (!inicialized) {
            String osName = System.getProperty("os.name");
            DLL_NAME = osName.contains("Linux") ? "libUsb4AllAPI.so" : "Usb4AllAPI.dll";
            inicialized = true;
        }
    }

    public static int apiVersion() throws NativeException, IllegalAccessException {
        if (f_apiVersion == null) {
            f_apiVersion = new JNative(DLL_NAME, "_ZN3u4a10apiVersionEv");
            f_apiVersion.setRetVal(Type.INT);
        }
        f_apiVersion.invoke();
        return new Integer(f_apiVersion.getRetVal());
    }

    public static int firmwareVersion() throws NativeException, IllegalAccessException {
        if (f_apiVersion == null) {
            f_apiVersion = new JNative(DLL_NAME, "_ZN3u4a15firmwareVersionEv");
            f_apiVersion.setRetVal(Type.INT);
        }
        f_apiVersion.invoke();
        return new Integer(f_apiVersion.getRetVal());
    }

    public static int closeDevice(int handler) throws NativeException, IllegalAccessException {
        if (f_closeDevice == null) {
            f_closeDevice = new JNative(DLL_NAME, "_ZN3u4a11closeDeviceEi");
            f_closeDevice.setRetVal(Type.INT);
        }
        f_closeDevice.setParameter(1, Type.INT, "" + handler);
        f_closeDevice.invoke();
        return new Integer(f_closeDevice.getRetVal());
    }

    public static int sendData(int handler, byte[] data, int len) throws NativeException, IllegalAccessException {
        return Usb4allAPIWrapper.sendData(handler, data, len, 3000);
    }

    public static int sendData(int handler, byte[] data, int len, int timeout) throws NativeException, IllegalAccessException {
        Pointer pData = new Pointer(MemoryBlockFactory.createMemoryBlock((int)255));
        pData.setMemory(data);
        if (f_sendData == null) {
            f_sendData = new JNative(DLL_NAME, "_ZN3u4a8sendDataEiPcii");
            f_sendData.setRetVal(Type.INT);
        }
        f_sendData.setParameter(1, Type.INT, "" + handler);
        f_sendData.setParameter(2, pData);
        f_sendData.setParameter(3, Type.INT, "" + len);
        f_sendData.setParameter(4, Type.INT, "" + timeout);
        f_sendData.invoke();
        return new Integer(f_sendData.getRetVal());
    }

    public static int openDevice(int idBoard, String devname, int usbin, int usbout) throws NativeException, IllegalAccessException {
        if (f_openDevice == null) {
            f_openDevice = new JNative(DLL_NAME, "_ZN3u4a10openDeviceEiPcii");
            f_openDevice.setRetVal(Type.INT);
        }
        int dataLength = devname.length() + 1;
        byte[] data = new byte[dataLength];
        int i = 0;
        while (i < devname.length()) {
            data[i] = (byte)devname.charAt(i);
            ++i;
        }
        data[dataLength - 1] = 0;
        Pointer pData = new Pointer(MemoryBlockFactory.createMemoryBlock((int)dataLength));
        pData.setMemory(data);
        System.out.println("usbin:" + usbin + " usbout:" + usbout);
        f_openDevice.setParameter(1, Type.INT, "" + idBoard);
        f_openDevice.setParameter(2, pData);
        f_openDevice.setParameter(3, Type.INT, "" + usbin);
        f_openDevice.setParameter(4, Type.INT, "" + usbout);
        System.out.println("Antes de hacer invoke() en USB4ALLAPIWrapper::openDevice(..)");
        f_openDevice.invoke();
        System.out.println("Despues de hacer invoke() en USB4ALLAPIWrapper::openDevice(..)");
        int ret = new Integer(f_openDevice.getRetVal());
        System.out.println("Despues de obtener el ret USB4ALLAPIWrapper::openDevice(..)");
        return ret;
    }

    public static ReadBytes receiveData(int handler, int len) throws NativeException, IllegalAccessException {
        return Usb4allAPIWrapper.receiveData(handler, len, -1);
    }

    public static ReadBytes receiveData(int handler, int len, int timeout) throws NativeException, IllegalAccessException {
        Pointer pData = new Pointer((MemoryBlock)new HeapMemoryBlock(255));
        if (f_receiveData == null) {
            f_receiveData = new JNative(DLL_NAME, "_ZN3u4a11receiveDataEiPcii");
            f_receiveData.setRetVal(Type.INT);
        }
        f_receiveData.setParameter(1, Type.INT, "" + handler);
        f_receiveData.setParameter(2, pData);
        f_receiveData.setParameter(3, Type.INT, "" + len);
        f_receiveData.setParameter(4, Type.INT, "" + timeout);
        f_receiveData.invoke();
        byte[] readBytes = pData.getMemory();
        ReadBytes ret = new ReadBytes(readBytes, len, Integer.parseInt(f_receiveData.getRetVal()));
        pData.dispose();
        return ret;
    }

    public static int getU4ABoards() throws NativeException, IllegalAccessException {
        int INT_SIZE = 4;
        Pointer pInt = new Pointer((MemoryBlock)new HeapMemoryBlock(INT_SIZE));
        if (f_getU4ABoards == null) {
            f_getU4ABoards = new JNative(DLL_NAME, "_ZN3u4a12getU4ABoardsERi");
            f_getU4ABoards.setRetVal(Type.INT);
        }
        f_getU4ABoards.setParameter(1, pInt);
        f_getU4ABoards.invoke();
        int cantBoards = pInt.getAsInt(0);
        pInt.dispose();
        return cantBoards;
    }

    public static int getSerialNumber(int boardNumber) throws NativeException, IllegalAccessException {
        if (f_getSerialNumber == null) {
            f_getSerialNumber = new JNative(DLL_NAME, "_ZN3u4a15getSerialNumberEi");
            f_getSerialNumber.setRetVal(Type.INT);
        }
        f_getSerialNumber.setParameter(1, Type.INT, "" + boardNumber);
        f_getSerialNumber.invoke();
        return new Integer(f_getSerialNumber.getRetVal());
    }

    public static void printByteArray(byte[] c) {
        int i = 0;
        while (i < c.length) {
            String s = Integer.toHexString(Byte.valueOf(c[i]).byteValue());
            s = s.length() > 1 ? s.substring(s.length() - 2) : "0" + s;
            System.out.print(String.valueOf(s) + " ");
            ++i;
        }
        System.out.println();
    }
}

