/**
 * 
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;

/**
 * @author Marc DENTY (mdt) - 14 nov. 06
 * $Id: Gdi32.java,v 1.1 2006/11/15 11:11:57 mdenty Exp $
 *
 */
public class Gdi32 {

	public static final String DLL_NAME = "Gdi32.dll";

    /**
     * <pre>
     * GetStockObject

The GetStockObject function retrieves a handle to one of the stock pens, brushes, fonts, or palettes.

HGDIOBJ GetStockObject(
  int fnObject   // stock object type
);
     * Parameters

fnObject
    [in] Specifies the type of stock object. This parameter can be one of the following values.
    Value 	Meaning
    BLACK_BRUSH 	Black brush.
    DKGRAY_BRUSH 	Dark gray brush.
    DC_BRUSH 	Windows 2000/XP: Solid color brush. The default color is white. The color can be changed by using the SetDCBrushColor function. For more information, see the Remarks section.
    GRAY_BRUSH 	Gray brush.
    HOLLOW_BRUSH 	Hollow brush (equivalent to NULL_BRUSH).
    LTGRAY_BRUSH 	Light gray brush.
    NULL_BRUSH 	Null brush (equivalent to HOLLOW_BRUSH).
    WHITE_BRUSH 	White brush.
    BLACK_PEN 	Black pen.
    DC_PEN 	Windows 2000/XP: Solid pen color. The default color is white. The color can be changed by using the SetDCPenColor function. For more information, see the Remarks section.
    WHITE_PEN 	White pen.
    ANSI_FIXED_FONT 	Windows fixed-pitch (monospace) system font.
    ANSI_VAR_FONT 	Windows variable-pitch (proportional space) system font.
    DEVICE_DEFAULT_FONT 	Windows NT/2000/XP: Device-dependent font.
    DEFAULT_GUI_FONT 	Default font for user interface objects such as menus and dialog boxes. This is MS Sans Serif. Compare this with SYSTEM_FONT.
    OEM_FIXED_FONT 	Original equipment manufacturer (OEM) dependent fixed-pitch (monospace) font.
    SYSTEM_FONT 	System font. By default, the system uses the system font to draw menus, dialog box controls, and text.

    Windows 95/98 and Windows NT: The system font is MS Sans Serif.

    Windows 2000/XP: The system font is Tahoma
    SYSTEM_FIXED_FONT 	Fixed-pitch (monospace) system font. This stock object is provided only for compatibility with 16-bit Windows versions earlier than 3.0.
    DEFAULT_PALETTE 	Default palette. This palette consists of the static colors in the system palette.

Return Values

If the function succeeds, the return value is a handle to the requested logical object.

If the function fails, the return value is NULL.

Windows NT/2000/XP: To get extended error information, call GetLastError.</pre>
     * @throws IllegalAccessException 
     * @throws NativeException 
*/
    public static LONG GetStockObject(int fnObject) throws NativeException, IllegalAccessException {
    	JNative getStockObject = new JNative(DLL_NAME, "GetStockObject");
    	getStockObject.setRetVal(Type.INT);
    	
    	getStockObject.setParameter(0, fnObject);
    	getStockObject.invoke();
    	
    	return new LONG(getStockObject.getRetValAsInt());
    }
	
}
