package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.WNDCLASS;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.LRESULT;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/**
 * User32 this is the class wrapper to User32.dll.<br>
 * When a developper needs a function of this DLL (s)he should add it here.
 * 
 * $Id: User32.java,v 1.14 2006/11/15 11:17:27 mdenty Exp $;
 * 
 * This software is released under the LGPL.
 * @author Created by Marc DENTY - (c) 2006 JNative project
 */
public class User32 {
	public static final String DLL_NAME = "User32.dll";

	private static JNative nEnumWindows;

	private static JNative nGetWindowText;

	private static Pointer nBufferGWT;

	/**
	 * HWND FindWindow(
	 * 
	 * LPCTSTR lpClassName, LPCTSTR lpWindowName );
	 */
	public static HWND findWindow(String className, String windowName)
			throws NativeException, IllegalAccessException {
		JNative _FindWindow = new JNative(DLL_NAME, "FindWindowA");
		_FindWindow.setRetVal(Type.INT);
		_FindWindow.setParameter(0, Type.STRING, className);
		_FindWindow.setParameter(1, Type.STRING, windowName);
		_FindWindow.invoke();
		int valRet = Integer.parseInt(_FindWindow.getRetVal());
		return new HWND(valRet);
	}

	public static LRESULT defWindowProc(HWND hwnd, UINT msg, WPARAM wparam,
			LPARAM lparam) throws NativeException, IllegalAccessException {
		JNative dwp = new JNative(DLL_NAME, "DefWindowProcA");
		dwp.setRetVal(Type.INT);
		dwp.setParameter(0, Type.INT, hwnd.getValueAsString());
		dwp.setParameter(1, Type.INT, msg.getValueAsString());
		dwp.setParameter(2, Type.INT, wparam.getValueAsString());
		dwp.setParameter(3, Type.INT, lparam.getValueAsString());
		dwp.invoke();
		return new LRESULT(Integer.parseInt(dwp.getRetVal()));
	}

	public static void updateWindow(HWND hwnd) throws NativeException,
			IllegalAccessException {
		JNative dm = new JNative(DLL_NAME, "UpdateWindow");
		dm.setParameter(0, Type.INT, hwnd.getValueAsString());
		dm.invoke();
		dm.dispose();
	}

	public static void dispatchMessage(MSG msg) throws NativeException,
			IllegalAccessException {
		JNative dm = new JNative(DLL_NAME, "DispatchMessageA");
		// dm.setRetVal(Type.INT);
		dm.setParameter(0, msg.getValue());
		dm.invoke();
		dm.dispose();
	}

	public static void translateMessage(MSG msg) throws NativeException,
			IllegalAccessException {
		JNative dm = new JNative(DLL_NAME, "TranslateMessage");
		// dm.setRetVal(Type.INT);
		dm.setParameter(0, msg.getValue());
		dm.invoke();
		dm.dispose();
	}

	public static int getMessage(MSG msg, HWND hwnd, int minMSG, int maxMSG)
			throws NativeException, IllegalAccessException {
		JNative gm = new JNative(DLL_NAME, "GetMessageA");
		gm.setRetVal(Type.INT);
		gm.setParameter(0, msg.getValue());
		gm.setParameter(1, Type.INT, hwnd.getValueAsString());
		gm.setParameter(2, Type.INT, "" + minMSG);
		gm.setParameter(3, Type.INT, "" + maxMSG);
		gm.invoke();
		return Integer.parseInt(gm.getRetVal());
	}

	public static boolean showWindow(HWND hwnd, int nCmdShow)
			throws NativeException, IllegalAccessException {
		JNative w = null;
		try {
			w = new JNative(DLL_NAME, "ShowWindow");
			w.setRetVal(Type.INT);
			w.setParameter(0, Type.INT, hwnd.getValueAsString());
			w.setParameter(1, Type.INT, "" + nCmdShow);
			w.invoke();
			return Integer.parseInt(w.getRetVal()) != 0;
		} finally {
			if (w != null)
				w.dispose();
		}
	}
	
	/**
	 * HWND CreateWindowEx( DWORD dwExStyle, LPCTSTR lpClassName, LPCTSTR
	 * lpWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND
	 * hWndParent, -3 for HWND_MESSAGE (Message only windows) HMENU hMenu,
	 * HINSTANCE hInstance, LPVOID lpParam );
	 */
	public static final int CreateWindowEx(int dwExStyle, String lpClassName,
			String lpWindowName, int dwStyle, int x, int y, int nWidth,
			int nHeight, int hWndParent, int hMenu, int hInstance, int lParam)
			throws NativeException, IllegalAccessException {
		return createWindowEx(dwExStyle, lpClassName, lpWindowName, dwStyle, x, y, nWidth, nHeight, hWndParent, hMenu, hInstance, lParam);
	}	
	/**
	 * HWND CreateWindowEx( DWORD dwExStyle, LPCTSTR lpClassName, LPCTSTR
	 * lpWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND
	 * hWndParent, -3 for HWND_MESSAGE (Message only windows) HMENU hMenu,
	 * HINSTANCE hInstance, LPVOID lpParam );
	 */
	public static final int createWindowEx(int dwExStyle, String lpClassName,
			String lpWindowName, int dwStyle, int x, int y, int nWidth,
			int nHeight, int hWndParent, int hMenu, int hInstance, int lParam)
			throws NativeException, IllegalAccessException {
		JNative n = null;
		try {
			n = new JNative(DLL_NAME, "CreateWindowExA");
			n.setRetVal(Type.INT);
			int i = 0;
			n.setParameter(i++, Type.INT, "" + dwExStyle);
			n.setParameter(i++, Type.STRING, lpClassName);
			if(lpWindowName == null) {
				n.setParameter(i++, 0);
			} else {
				n.setParameter(i++, lpWindowName);
			}
			n.setParameter(i++, Type.INT, "" + dwStyle);
			n.setParameter(i++, Type.INT, "" + x);
			n.setParameter(i++, Type.INT, "" + y);
			n.setParameter(i++, Type.INT, "" + nWidth);
			n.setParameter(i++, Type.INT, "" + nHeight);
			n.setParameter(i++, Type.INT, "" + hWndParent);
			n.setParameter(i++, Type.INT, "" + hMenu);
			n
					.setParameter(i++, Type.INT, ""
							+ (hInstance == 0 ? JNative.getCurrentModule()
									: hInstance));
			n.setParameter(i++, Type.INT, "" + lParam);
			n.invoke();
			return Integer.parseInt(n.getRetVal());
		} finally {
			if (n != null) {
				n.dispose();
			}
		}
	}

	public static final int CreateWindowEx(int dwExStyle, LONG lpClassName,
			String lpWindowName, int dwStyle, int x, int y, int nWidth,
			int nHeight, int hWndParent, int hMenu, int hInstance, int lParam)
			throws NativeException, IllegalAccessException {
		JNative n = null;
		try {
			n = new JNative(DLL_NAME, "CreateWindowExA");
			n.setRetVal(Type.INT);
			int i = 0;
			n.setParameter(i++, Type.INT, "" + dwExStyle);
			n.setParameter(i++, lpClassName.getValue());
			if(lpWindowName == null) {
				n.setParameter(i++, 0);
			} else {
				n.setParameter(i++, lpWindowName);
			}
			n.setParameter(i++, Type.INT, "" + dwStyle);
			n.setParameter(i++, Type.INT, "" + x);
			n.setParameter(i++, Type.INT, "" + y);
			n.setParameter(i++, Type.INT, "" + nWidth);
			n.setParameter(i++, Type.INT, "" + nHeight);
			n.setParameter(i++, Type.INT, "" + hWndParent);
			n.setParameter(i++, Type.INT, "" + hMenu);
			n
					.setParameter(i++, Type.INT, ""
							+ (hInstance == 0 ? JNative.getCurrentModule()
									: hInstance));
			n.setParameter(i++, Type.INT, "" + lParam);
			n.invoke();
			return Integer.parseInt(n.getRetVal());
		} finally {
			if (n != null) {
				n.dispose();
			}
		}
	}

	public static final int messageBox(int parentHandle, String message,
			String caption, int buttons) throws NativeException,
			IllegalAccessException {
		JNative n = null;
		try {
			n = new JNative(DLL_NAME, "MessageBoxA");
			n.setRetVal(Type.INT);
			int i = 0;
			n.setParameter(i++, Type.INT, "" + parentHandle);
			n.setParameter(i++, Type.STRING, message);
			n.setParameter(i++, Type.STRING, caption);
			n.setParameter(i++, Type.INT, "" + buttons);
			n.invoke();
			return Integer.parseInt(n.getRetVal());
		} finally {
			if (n != null)
				n.dispose();
		}
	}

	/**
	 * <pre>
	 *  EnumWindows Function
	 * 
	 * 	 The EnumWindows function enumerates all top-level windows on the screen by passing the handle to each window, in turn, to an application-defined callback function. EnumWindows continues until the last top-level window is enumerated or the callback function returns FALSE.
	 * 
	 * 	 Syntax
	 * 
	 * 	 BOOL EnumWindows(
	 * 
	 * 	 WNDENUMPROC lpEnumFunc,
	 * 	 LPARAM lParam
	 * 	 );
	 * 
	 * 	 Parameters
	 * 
	 * 	 lpEnumFunc
	 * 	 [in] Pointer to an application-defined callback function. For more information, see EnumWindowsProc.
	 * 	 lParam
	 * 	 [in] Specifies an application-defined value to be passed to the callback function.
	 * 
	 * 	 Return Value
	 * 
	 * 	 If the function succeeds, the return value is nonzero.
	 * 
	 * 	 If the function fails, the return value is zero. To get extended error information, call GetLastError.
	 * 
	 * 	 If EnumWindowsProc returns zero, the return value is also zero. In this case, the callback function should call SetLastError to obtain a meaningful error code to be returned to the caller of EnumWindows.
	 * 
	 * 
	 * 	 Remarks
	 * 
	 * 	 The EnumWindows function does not enumerate child windows, with the exception of a few top-level windows owned by the system that have the WS_CHILD style.
	 * 
	 * 	 This function is more reliable than calling the GetWindow function in a loop. An application that calls GetWindow to perform this task risks being caught in an infinite loop or referencing a handle to a window that has been destroyed.
	 * 
	 * </pre>
	 * 
	 * lpEnumFunc must be the address returned by JNative.createCallback()
	 */

	public static boolean EnumWindows(Callback lpEnumFunc, int lParam)
			throws NativeException, IllegalAccessException {
		if (nEnumWindows == null) {
			nEnumWindows = new JNative(DLL_NAME, "EnumWindows", false);
			nEnumWindows.setRetVal(Type.INT);
		}
		nEnumWindows.setParameter(0, lpEnumFunc.getCallbackAddress());
		nEnumWindows.setParameter(1, lParam);
		nEnumWindows.invoke();
		return !"0".equals(nEnumWindows.getRetVal());
	}

	public static String GetWindowText(HWND hwnd) throws NativeException,
			IllegalAccessException {
		if (nGetWindowText == null) {
			nGetWindowText = new JNative(DLL_NAME, "GetWindowTextA");
			nGetWindowText.setRetVal(Type.INT);
			nBufferGWT = new Pointer(MemoryBlockFactory.createMemoryBlock(512));
			nGetWindowText.setParameter(1, nBufferGWT);
			nGetWindowText.setParameter(2, nBufferGWT.getSize());
		}
		nGetWindowText.setParameter(0, hwnd.getValue());
		nGetWindowText.invoke();
		if ("0".equals(nGetWindowText.getRetVal())) {
			return "";
		} else {
			return nBufferGWT.getAsString();
		}
	}

	// ***** START SetWindowPos METHOD
	/**
	 * BOOL SetWindowPos( HWND hWndInsertAfter, int x, int y, int cx, int cy,
	 * UINT nFlags );
	 * 
	 * @author  JBerry76_ITA
	 * @param hwnd
	 *            HWND
	 * @param hWndInsertAfter
	 *            int
	 * @param x
	 *            int Specifies the new position of the left side of the window.
	 * @param y
	 *            int Specifies the new position of the top of the window.
	 * @param cx
	 *            int Specifies the new width of the window.
	 * @param cy
	 *            int Specifies the new height of the window.
	 * @param wFlags
	 *            int Specifies sizing and positioning options.
	 * @return HWND
	 * @throws NativeException
	 * @throws IllegalAccessException
	 */

	public static boolean setWindowPos(HWND hwnd, int hWndInsertAfter, int x,
			int y, int cx, int cy, int wFlags) throws NativeException,
			IllegalAccessException {
		JNative _setWindowPos = new JNative(DLL_NAME, "SetWindowPos");
		_setWindowPos.setRetVal(Type.INT);

		_setWindowPos.setParameter(0, hwnd.getValue());
		_setWindowPos.setParameter(1, hWndInsertAfter);
		_setWindowPos.setParameter(2, x);
		_setWindowPos.setParameter(3, y);
		_setWindowPos.setParameter(4, cx);
		_setWindowPos.setParameter(5, cy);
		_setWindowPos.setParameter(6, wFlags);
		_setWindowPos.invoke();
		int valRet = Integer.parseInt(_setWindowPos.getRetVal());
		return (valRet == 1);
	}
	// ***** END SetWindowPos METHOD

	/**
	 * LONG SetWindowLong(      
	 *  HWND hWnd,
	 *  int nIndex,
	 *  LONG dwNewLong
	 * );
	 * @throws NativeException 
	 * @throws IllegalAccessException 
	 */
	public static int SetWindowLong(HWND hwnd, int nIndex, LONG dwNewLong) throws NativeException, IllegalAccessException {
		JNative _setWindowLong = new JNative(DLL_NAME, "SetWindowLongA");
		_setWindowLong.setRetVal(Type.INT);
		
		_setWindowLong.setParameter(0, hwnd.getValue());
		_setWindowLong.setParameter(1, nIndex);
		_setWindowLong.setParameter(2, dwNewLong.getValue());
		_setWindowLong.invoke();
		
		return _setWindowLong.getRetValAsInt();
	}

	
	/**
	 * <pre>
	 * RegisterClass Function

The RegisterClass function registers a window class for subsequent use in calls to the CreateWindow or CreateWindowEx function.

The RegisterClass function has been superseded by the RegisterClassEx function. You can still use RegisterClass, however, if you do not need to set the class small icon.

Syntax

    ATOM RegisterClass(      

        CONST WNDCLASS *lpWndClass
    );

Parameters

    lpWndClass
        [in] Pointer to a WNDCLASS structure. You must fill the structure with the appropriate class attributes before passing it to the function. 

Return Value

    If the function succeeds, the return value is a class atom that uniquely identifies the class being registered. This atom can only be used by the CreateWindow, CreateWindowEx, GetClassInfo, GetClassInfoEx, FindWindow, FindWindowEx, and UnregisterClass functions and the IActiveIMMap::FilterClientWindows method.

    If the function fails, the return value is zero. To get extended error information, call GetLastError. 
	 * </pre>
	 * @return
	 * @throws IllegalAccessException 
	 * @throws NativeException 
	 */
	public static LONG RegisterClass(WNDCLASS lpWndClass) throws NativeException, IllegalAccessException {
		JNative registerClass = new JNative(DLL_NAME, "RegisterClassA");
		registerClass.setRetVal(Type.INT);
		
		registerClass.setParameter(0, lpWndClass.createPointer());
		registerClass.invoke();
		return new LONG(registerClass.getRetValAsInt());
	}
	
	/**
	 * <pre>
    HICON LoadIcon(      

            HINSTANCE hInstance,
            LPCTSTR lpIconName
        );

    Parameters

        hInstance
            [in] Handle to an instance of the module whose executable file contains the icon to be loaded. This parameter must be NULL when a standard icon is being loaded. 
        lpIconName
            [in] 

            Pointer to a null-terminated string that contains the name of the icon resource to be loaded. Alternatively, this parameter can contain the resource identifier in the low-order word and zero in the high-order word. Use the MAKEINTRESOURCE macro to create this value.

            To use one of the predefined icons, set the hInstance parameter to NULL and the lpIconName parameter to one of the following values.

            IDI_APPLICATION
                Default application icon.
            IDI_ASTERISK
                Same as IDI_INFORMATION.
            IDI_ERROR
                Hand-shaped icon.
            IDI_EXCLAMATION
                Same as IDI_WARNING.
            IDI_HAND
                Same as IDI_ERROR. 
            IDI_INFORMATION
                Asterisk icon.
            IDI_QUESTION
                Question mark icon.
            IDI_WARNING
                Exclamation point icon.
            IDI_WINLOGO
                Windows logo icon. Windows XP: Default application icon.
            IDI_SHIELD
                Security Shield icon. 

    Return Value

        If the function succeeds, the return value is a handle to the newly loaded icon.

        If the function fails, the return value is NULL. To get extended error information, call GetLastError.
        
        </pre>
	 * @throws IllegalAccessException 
	 * @throws NativeException 
    */

	public static LONG LoadIcon(LONG hInstance, String lpIconName) throws NativeException, IllegalAccessException {
    	JNative loadIcon = new JNative(DLL_NAME, "LoadIconA");
    	loadIcon.setRetVal(Type.INT);
    	
    	loadIcon.setParameter(0, hInstance.getValue());
    	loadIcon.setParameter(1, lpIconName);
    	loadIcon.invoke();
    	
    	return new LONG(loadIcon.getRetValAsInt());
    }

    public static LONG LoadIcon(LONG hInstance, int ressource) throws NativeException, IllegalAccessException {
    	JNative loadIcon = new JNative(DLL_NAME, "LoadIconA");
    	loadIcon.setRetVal(Type.INT);
    	
    	loadIcon.setParameter(0, hInstance.getValue());
    	loadIcon.setParameter(1, ressource);
    	loadIcon.invoke();
    	
    	return new LONG(loadIcon.getRetValAsInt());
    }
/**
 * <pre>
 * SendMessage Function

The SendMessage function sends the specified message to a window or windows. It calls the window procedure for the specified window and does not return until the window procedure has processed the message.

To send a message and return immediately, use the SendMessageCallback or SendNotifyMessage function. To post a message to a thread's message queue and return immediately, use the PostMessage or PostThreadMessage function.

Syntax

    LRESULT SendMessage(      

        HWND hWnd,
        UINT Msg,
        WPARAM wParam,
        LPARAM lParam
    );

Parameters

    hWnd
        [in] Handle to the window whose window procedure will receive the message. If this parameter is HWND_BROADCAST, the message is sent to all top-level windows in the system, including disabled or invisible unowned windows, overlapped windows, and pop-up windows; but the message is not sent to child windows.
    Msg
        [in] Specifies the message to be sent.
    wParam
        [in] Specifies additional message-specific information.
    lParam
        [in] Specifies additional message-specific information.

Return Value

    The return value specifies the result of the message processing; it depends on the message sent.
    </pre>
 * @throws IllegalAccessException 
 * @throws NativeException 
 */
    public static LRESULT SendMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam) throws NativeException, IllegalAccessException {
    	JNative SendMessage = new JNative(DLL_NAME, "SendMessageA");
    	SendMessage.setRetVal(Type.INT);
    	int pos = 0;
    	SendMessage.setParameter(pos++, hWnd.getValue());
    	SendMessage.setParameter(pos++, Msg.getValue());
    	SendMessage.setParameter(pos++, wParam.getValue());
    	SendMessage.setParameter(pos++, lParam.getValue());
    	SendMessage.invoke();
    	return new LRESULT(SendMessage.getRetValAsInt());
    }

    
}
