/*
 * StructConverter.java -
 *
 * This file is part of the Jawin Project: http://jawinproject.sourceforge.net/
 *
 * Please consult the LICENSE file in the project root directory,
 * or at the project site before using this software.
 */


/*
 * The DevelopMentor OpenSource Software License Version 0.9
 * Copyright (c) 2001 DevelopMentor.  All rights reserved.
 *
 * The official URL for this license is
 *    http://staff.develop.com/halloway/DMOpenSourceLicense.txt
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *    "This product includes software developed by the DevelopMentor
 *    OpenSource Project (http://www.develop.com/OpenSource)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The name "DevelopMentor" may not be used to name, endorse, or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact opensource@develop.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL DEVELOPMENTOR OPENSOURCE OR ITS
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/* $Id: StructConverter.java,v 1.3 2006/11/25 10:42:52 mdenty Exp $ */

package org.xvolks.jnative.util;


public class StructConverter {
	
	/**
	 * private constructor to avoid instantiation, as this class only contains
	 * static methods.
	 */
	private StructConverter() {
		// never called
	}
	
	/*
	 public static INative structToMem(IStruct s)
	 throws COMException
	 {
	 byte[] bytes = s.instToBytes();
	 System.out.println(HexFormatter.convertBytesToString(bytes, 16, true));
	 if (bytes == null)  {
	 throw new Error("reflective marshalling not implemented yet");
	 }
	 MemPtr mp = new MemPtr(bytes);
	 return mp;
	 }
	 */
	
	/**
	 * @param val max 16 characters long. Should not contain any '0x'-prefix.
	 * 			the empty string will return 0.
	 * @throws NumberFormatException if val is longer than 16 characters
	 * 			or if val contains non parseable characters ([0-9, a-f, A-F] is legal).
	 * @throws NullPointerException if val is null.
	 * @see #parseInt(String)
	 */
	public static long parseLong(String val) {
		return parseHex(val, 16);
	}
	
	/**
	 * parse a hex string into an int. This method differs from
	 * {@link Integer#parseInt(java.lang.String, int) Integer.parseInt(val, 16)}
	 * in that it does not allow '-' and allows the full range of eight
	 * hex characters (eg. 'FFFFFFFF' is allowed). Since int is signed
	 * the string is parsed in the standard signed 2-complement
	 * representaion, eg:
	 * <ul>
	 * 	<li>7FFFFFFF -> {@link Integer#MAX_VALUE Integer.MAX_VALUE}</li>
	 * 	<li>80000000 -> {@link Integer#MIN_VALUE Integer.MIN_VALUE}</li>
	 * 	<li>FFFFFFFF -> -1</li>
	 * </ul>
	 *
	 * @param val max 8 characters long. Should not contain any '0x'-prefix.
	 * 			the empty string will return 0.
	 * @throws NumberFormatException if val is longer than 8 characters
	 * 			or if val contains non parseable characters ([0-9, a-f, A-F] is legal).
	 * @throws NullPointerException if val is null.
	 */
	public static int parseInt(String val) {
		return (int)parseHex(val, 8);
	}
	
	/**
	 * @param val max 4 characters long. Should not contain any '0x'-prefix.
	 * 			the empty string will return 0.
	 * @throws NumberFormatException if val is longer than 4 characters
	 * 			or if val contains non parseable characters ([0-9, a-f, A-F] is legal).
	 * @throws NullPointerException if val is null.
	 * @see #parseInt(String)
	 */
	public static short parseShort(String val) {
		return (short)parseHex(val, 4);
	}
	
	/**
	 * @param maxChars the maximum number of hex digits, should be in the range ]0; 16]
	 * @throws NumberFormatException if unable to parse val.
	 */
	private static long parseHex(String val, int maxChars) {
		int length = val.length();
		if(length > maxChars) {
			throw new NumberFormatException("unable to parse: '" + val + "' (too many digits)");
		}
		int shift = 0;
		long res = 0;
		for(int i = length - 1; i >= 0; i--) {
			int digit = Character.digit(val.charAt(i), 16);
			if(digit < 0) {
				throw new NumberFormatException("unable to parse: '" + val + "' (invalid char at pos: " + i + ")");
			}
			res += ((long)digit) << shift;
			shift += 4;
		}
		return res;
	}
	
//	static public int longIntoBEBytes(long data, byte[] bytes, int start) {
//		bytes[start++] = (byte) (data >>> 56);
//		bytes[start++] = (byte) (data >>> 48);
//		bytes[start++] = (byte) (data >>> 40);
//		bytes[start++] = (byte) (data >>> 32);
//		bytes[start++] = (byte) (data >>> 24);
//		bytes[start++] = (byte) (data >>> 16);
//		bytes[start++] = (byte) (data >>> 8);
//		bytes[start++] = (byte) (data);
//		return start;
//	}
	
	static public long bytesIntoLong(byte[] bytes, int offset) {
		int nLo = bytesIntoInt(bytes, offset);
		int nHi = bytesIntoInt(bytes, offset + 4);
		return ((long)(nHi) << 32) + (nLo & 0xFFFFFFFFL);
	}
	
	static public double bytesIntoDouble(byte[] bytes, int offset) {
		double d = Double.longBitsToDouble(bytesIntoLong(bytes, offset));
		return d;
	}
	
	static public float bytesIntoFloat(byte[] bytes, int offset) {
		float f = Float.intBitsToFloat(bytesIntoInt(bytes, offset));
		return f;
	}
	
	
	static public boolean bytesIntoBoolean(byte[] bytes, int offset) {
		return bytes[offset] != 0;
	}
	
	static public int bytesIntoInt(byte[] bytes, int offset) {
		int l = (bytes[offset+0] & 0xff) |
			((bytes[offset + 1] & 0xff) << 8) |
			((bytes[offset + 2] & 0xff) << 16) |
			((bytes[offset + 3] & 0xff) << 24);
		return l;
	}
	
//	static public int BEBytesIntoInt(byte[] bytes, int offset) {
//		int l = (bytes[offset + 3] & 0xff) |
//			((bytes[offset + 2] & 0xff) << 8) |
//			((bytes[offset + 1] & 0xff) << 16) |
//			((bytes[offset + 0] & 0xff) << 24);
//		return l;
//	}
	
	static public short bytesIntoShort(byte[] bytes, int offset) {
		int l =  (bytes[offset] & 0xff) |
			((bytes[offset + 1] & 0xff) << 8);
		return (short) l;
	}
	
	static public int longIntoBytes(long data, byte[] bytes, int start) {
		bytes[start++] = (byte) (data);
		bytes[start++] = (byte) (data >>> 8);
		bytes[start++] = (byte) (data >>> 16);
		bytes[start++] = (byte) (data >>> 24);
		bytes[start++] = (byte) (data >>> 32);
		bytes[start++] = (byte) (data >>> 40);
		bytes[start++] = (byte) (data >>> 48);
		bytes[start++] = (byte) (data >>> 56);		
		return start;
	}
	
	static public int floatIntoBytes(float f, byte[] bytes, int start) {
		int data = Float.floatToIntBits(f); 
		bytes[start++] = (byte) (data);
		bytes[start++] = (byte) (data >>> 8);
		bytes[start++] = (byte) (data >>> 16);
		bytes[start++] = (byte) (data >>> 24);		
		return start;
	}

	static public int doubleIntoBytes(double d, byte[] bytes, int start) {
		long data = Double.doubleToLongBits(d); 
		bytes[start++] = (byte) (data);
		bytes[start++] = (byte) (data >>> 8);
		bytes[start++] = (byte) (data >>> 16);
		bytes[start++] = (byte) (data >>> 24);
		bytes[start++] = (byte) (data >>> 32);
		bytes[start++] = (byte) (data >>> 40);
		bytes[start++] = (byte) (data >>> 48);
		bytes[start++] = (byte) (data >>> 56);		
		return start;
	}

	static public int intIntoBytes(int data, byte[] bytes, int start) {
		bytes[start++] = (byte) (data);
		bytes[start++] = (byte) (data >>> 8);
		bytes[start++] = (byte) (data >>> 16);
		bytes[start++] = (byte) (data >>> 24);
		return start;
	}
	
	static public int shortIntoBytes(short data, byte[] bytes, int start) {
		bytes[start++] = (byte) (data);
		bytes[start++] = (byte) (data >>> 8);
		return start;
	}
	
	static public int byteArrayIntoBytes(byte[] src, byte[] dest, int start) {
		System.arraycopy(src, 0, dest, start, src.length);
		return start + src.length;
	}
}
