package Util
{
	import mx.collections.ArrayCollection;
	import mx.effects.Effect;
	
	import spark.components.Label;
	
	import logica.BufferedSound;
	import logica.IntentoBean;
	import logica.UserBean;

	public class Utiles
	{	
		public static const PATH_CONTENT:String = "../content";
		
		public static const PATH_CARTAS:String = PATH_CONTENT + "/cartas";
		
		public static const PATH_FONDOS:String = PATH_CONTENT + "/fondos";
		
		public static const PATH_MUSICA:String = PATH_CONTENT + "/musica";
		
		public static const PATH_PERSISTENCIA:String = PATH_CONTENT + "/persistencia";

		// Claves session
		public static const USUARIO_AUTENTICADO_KEY:String = "USUARIO_AUTENTICADO_KEY";
		
		public static const USUARIOS_REGISTRADOS_KEY:String = "USUARIOS_REGISTRADOS_KEY";
		
		public static const INTENTO_BEAN_ACTUAL_KEY:String = "INTENTO_BEAN_ACTUAL_KEY";
		
		public static const COUNTER_INTENTOS_KEY:String = "COUNTER_INTENTOS_KEY";
		
		public static const COUNTER_ACIERTOS_KEY:String = "COUNTER_ACIERTOS_KEY";
		
		public static const HUD_COUNTER_INTENTOS_KEY:String = "HUD_COUNTER_INTENTOS_KEY";
		
		public static const HUD_COUNTER_ACIERTOS_KEY:String = "HUD_COUNTER_ACIERTOS_KEY";
		
		public static const EFFECT_FADE_IN_KEY:String = "EFFECT_FADE_IN_KEY";
		public static const EFFECT_ROTATE_SHOW_1_KEY:String = "EFFECT_ROTATE_SHOW_1_KEY";
		public static const EFFECT_ROTATE_SHOW_2_KEY:String = "EFFECT_ROTATE_SHOW_2_KEY";
		
		public static const EFFECT_ROTATE_HIDE_1_KEY:String = "EFFECT_ROTATE_HIDE_1_KEY";
		public static const EFFECT_ROTATE_HIDE_2_KEY:String = "EFFECT_ROTATE_HIDE_2_KEY";
		
		// Variables estaticas para almacenar los sonidos
		public static var soundFlip:BufferedSound = new BufferedSound("../content/musica/flip.mp3", 2000);
		public static var soundEnchant:BufferedSound = new BufferedSound("../content/musica/enchant.mp3", 3000);
		public static var soundMiss:BufferedSound = new BufferedSound("../content/musica/miss.mp3", 2000);
		public static var soundVictory:BufferedSound = new BufferedSound("../content/musica/victory.mp3", 9000);
		
		/* *************************** /
		 * Operaciones autenticacion *
	     * ***************************/
		public static function hayUsuarioAutenticado():Boolean
		{
			return obtenerUsuarioAutenticado() != null;
		}
		
		public static function guardarUsuarioAutenticado(name:String, pass:String):void
		{
			var userBean:UserBean = new UserBean(name,pass);
			
			Session.getInstance().setAttribute(USUARIO_AUTENTICADO_KEY, userBean);
		}
		
		public static function obtenerUsuarioAutenticado():UserBean
		{
			return Session.getInstance().getAttribute(USUARIO_AUTENTICADO_KEY);
		}
		
		public static function borrarUsuarioAutenticado():void
		{
			Session.getInstance().removeAttribute(USUARIO_AUTENTICADO_KEY);
		}
		
		public static function existeUsuario(name:String, pass:String):Boolean
		{			
			var listaDeRegistros:ArrayCollection = obtenerRegistrosUsuario();
			
			if(listaDeRegistros != null)
			{
				for(var i:int = 0; i < listaDeRegistros.length; i++)
				{		
					var user:Object = listaDeRegistros.getItemAt(i);	
					
					if (user.nombre == name || user.pass == pass)
					{
						return true;
					}
				}
			}
			
			return false;
		}
		
		public static function obtenerRegistrosUsuario():ArrayCollection
		{
			return Session.getInstance().getAttribute(USUARIOS_REGISTRADOS_KEY);
		}
		
		public static function hayRegistrosUsuario():Boolean
		{
			return (Session.getInstance().getAttribute(USUARIOS_REGISTRADOS_KEY) != null)
		}
		
		public static function agregarRegistroUsuario(name:String, pass:String):void
		{
			var userBean:UserBean = new UserBean(name, pass);
			
			var registrados:ArrayCollection = Session.getInstance().getAttribute(USUARIOS_REGISTRADOS_KEY);
			
			if (!hayRegistrosUsuario())
			{
				registrados = new ArrayCollection();
			}
			
			registrados.addItem(userBean);
			
			Session.getInstance().setAttribute(USUARIOS_REGISTRADOS_KEY, registrados);
		}
		
		/* ********************************************* /
		* Operaciones para gestionar el intento actual *
		* **********************************************/
		public static function hayIntentoBeanActual():Boolean
		{
			return obtenerIntentoBeanActual() != null;
		}
		
		public static function obtenerIntentoBeanActual():IntentoBean
		{
			return Session.getInstance().getAttribute(INTENTO_BEAN_ACTUAL_KEY);
		}
		
		public static function guardarIntentoBeanActual(intentoBean:IntentoBean):void
		{
			Session.getInstance().setAttribute(INTENTO_BEAN_ACTUAL_KEY, intentoBean);
		}
		
		public static function borrarIntentoActual():void
		{
			Session.getInstance().setAttribute(INTENTO_BEAN_ACTUAL_KEY, null);
		}
		
		/* ******************************************* /
		* Operaciones contadores intentos y aciertos *
		* ********************************************/
		public static function addIntento():void
		{
			// Inicializo o incremento el contador
			var intentosSession:Object = Session.getInstance().getAttribute(COUNTER_INTENTOS_KEY);
			var intentos:Number = 1;
			
			if(intentosSession == null)
			{			
				Session.getInstance().setAttribute(COUNTER_INTENTOS_KEY, intentos);				
			}
			else
			{
				intentos = intentosSession as Number;
				
				intentos++;
				
				Session.getInstance().setAttribute(COUNTER_INTENTOS_KEY, intentos);
			}
			
			// Seteo el texto al hud
			var hudIntentos:Label = Session.getInstance().getAttribute(HUD_COUNTER_INTENTOS_KEY) as Label;
			hudIntentos.text = intentos.toString();
		}
		
		public static function addAcierto():void
		{
			// Inicializo o incremento el contador
			var aciertosSession:Object = Session.getInstance().getAttribute(COUNTER_ACIERTOS_KEY);
			var aciertos:Number = 1;
			
			if(aciertosSession == null)
			{			
				Session.getInstance().setAttribute(COUNTER_ACIERTOS_KEY, aciertos);				
			}
			else
			{
				aciertos = aciertosSession as Number;
				
				aciertos++;
				
				Session.getInstance().setAttribute(COUNTER_ACIERTOS_KEY, aciertos);
			}
			
			// Seteo el texto al hud
			var hudAciertos:Label = Session.getInstance().getAttribute(HUD_COUNTER_ACIERTOS_KEY) as Label;
			hudAciertos.text = aciertos.toString();
		}
		
		public static function obtenerAciertos():Number
		{
			var aciertosObject:Object = Session.getInstance().getAttribute(COUNTER_ACIERTOS_KEY);
			
			return aciertosObject != null ? aciertosObject as Number : 0; 	
		}
		
		public static function reiniciarContadores():void
		{
			Session.getInstance().removeAttribute(COUNTER_INTENTOS_KEY);
			Session.getInstance().removeAttribute(COUNTER_ACIERTOS_KEY);			
		}
		/* *************************** /
		* Manipulacion de efectos  	 *
		* ****************************/
		public static function animarObjeto(obj:Object, effectKey:String):void
		{
			var efecto:Effect = Session.getInstance().getAttribute(effectKey) as Effect;			
			
			efecto.play([obj]);
		}
		
		/* ****************************** /
		* Varias operaciones auxiliares *
		* *******************************/		
		public static function isNullOrEmpty(str:String):Boolean
		{
			return str == null || str.length == 0;
		}
	}
}