package logica
{
	import mx.collections.ArrayCollection;	
	import Util.Utiles;

	public class CartasEnum
	{
		public static const CARTA_TRASERA:CartaBean = new CartaBean(0, "Trasera", Utiles.PATH_CARTAS + "/carta_trasera.jpg");
		
		public static const CARTA_AMUN:CartaBean = new CartaBean(1, "Amun", Utiles.PATH_CARTAS + "/carta_amun.jpg");
		
		public static const CARTA_ANUBIS:CartaBean = new CartaBean(2, "Anubis", Utiles.PATH_CARTAS + "/carta_anubis.jpg");
		
		public static const CARTA_ESFINGE:CartaBean = new CartaBean(3, "Esfinge", Utiles.PATH_CARTAS + "/carta_esfinge.jpg");
		
		public static const CARTA_EXPLORADORA:CartaBean = new CartaBean(4, "Exploradora", Utiles.PATH_CARTAS + "/carta_exploradora.jpg");
		
		public static const CARTA_LADRON:CartaBean = new CartaBean(5, "Ladron", Utiles.PATH_CARTAS + "/carta_ladron.jpg");
		
		public static const CARTA_MOMIA:CartaBean = new CartaBean(6, "Momia", Utiles.PATH_CARTAS + "/carta_momia.jpg");
		
		public static const CARTA_OSIRIS:CartaBean = new CartaBean(7, "Osiris", Utiles.PATH_CARTAS + "/carta_osiris.jpg");
		
		public static const CARTA_PIRAMIDES:CartaBean = new CartaBean(8, "Piramides", Utiles.PATH_CARTAS + "/carta_piramides.jpg");
		
		public static const CARTA_RA:CartaBean = new CartaBean(9, "Ra", Utiles.PATH_CARTAS + "/carta_ra.jpg");
		
		public static const CARTA_SARCOFAGO:CartaBean = new CartaBean(10, "Sarcofago", Utiles.PATH_CARTAS + "/carta_sarcofago.jpg");
		
		public static const CARTA_SET:CartaBean = new CartaBean(11, "Set", Utiles.PATH_CARTAS + "/carta_set.jpg");
		 
		public static const CARTA_TESOROS:CartaBean = new CartaBean(12, "Tesoros", Utiles.PATH_CARTAS + "/carta_tesoros.jpg");
		
		public static function getJuegoCartas() : ArrayCollection
		{
			var collectionCartas : ArrayCollection = new ArrayCollection();					
			collectionCartas.addItem(CARTA_AMUN);			
			collectionCartas.addItem(CARTA_ANUBIS);			
			collectionCartas.addItem(CARTA_ESFINGE);			
			collectionCartas.addItem(CARTA_EXPLORADORA);			
			collectionCartas.addItem(CARTA_LADRON);			
			collectionCartas.addItem(CARTA_MOMIA);			
			collectionCartas.addItem(CARTA_OSIRIS);			
			collectionCartas.addItem(CARTA_PIRAMIDES);
			collectionCartas.addItem(CARTA_RA);			
			collectionCartas.addItem(CARTA_SARCOFAGO);			
			collectionCartas.addItem(CARTA_SET);
			collectionCartas.addItem(CARTA_TESOROS);
			
			return collectionCartas;
		}
		
		public static function getRandomArray():Array
		{
			// Genero dos juegos de cartas
			var collectionCartas:ArrayCollection = new ArrayCollection();
			collectionCartas.addAll(getJuegoCartas());
			collectionCartas.addAll(getJuegoCartas());
			
			// Genero un array de orden aleatorio			
			var arrayCartas:Array = new Array();
			for(var i:int = 0; i < collectionCartas.length; i++)
			{
				var currentPos:int;				
				do
				{
					currentPos = getRandonNumber();
				}
				while(arrayCartas[currentPos] != null);
				
				arrayCartas[currentPos] = collectionCartas.getItemAt(i);												
			}
			
			return arrayCartas;
		}
		
		private static function getRandonNumber():int
		{
			var low:Number = 0;			
			var high:Number= 23;			
			
			return Math.floor(Math.random() * (1 + high - low)) + low;
		}
	}
}