package logica
{
	import flash.events.MouseEvent;
	
	import mx.containers.GridItem;
	import mx.controls.Alert;
	
	import spark.components.Image;
	
	import Util.Utiles;

	public class CeldaBean
	{
		public var carta:CartaBean;
		
		public var itemGrilla:GridItem;
		
		public var imagen:Image;
		
		function CeldaBean(numCelda:int, carta:CartaBean)
		{				
			this.carta = carta;
			
			this.imagen = new Image();
			this.imagen.source = CartasEnum.CARTA_TRASERA.path;
			
			this.itemGrilla = new GridItem();
			this.itemGrilla.id = "c_" + numCelda;
			this.itemGrilla.width = 115;
			this.itemGrilla.height = 120;
			this.itemGrilla.addChild(imagen);			
			this.itemGrilla.addEventListener(MouseEvent.CLICK, handleOnClickCelda);		
			
			Utiles.animarObjeto(this.imagen, Utiles.EFFECT_FADE_IN_KEY);			
		}
		
		private function handleOnClickCelda(event:MouseEvent): void
		{	
			// Si no hay un intento activo inicio uno nuevo y le seteo la primera carta
			if(!isVista())
			{				
				var intentoActual:IntentoBean = Utiles.obtenerIntentoBeanActual();
		
				if(intentoActual == null || !intentoActual.isComplete)
				{
					// Sonido flip	
					Utiles.soundFlip.play();
					
					// Creacion del intento
					if(intentoActual == null)
					{							
						Utiles.guardarIntentoBeanActual(new IntentoBean(this));
					}
					else
					{
						if(!intentoActual.isComplete)
						{
							intentoActual.resolverIntento(this);
						}
					}				
				}				
			}
		}	
		
		public function isVista():Boolean
		{			
			var vista:Boolean = this.imagen.source != CartasEnum.CARTA_TRASERA.path;
			
			return vista;
		}
	}
}