package logica
{
	import flash.utils.setTimeout;
	
	import mx.events.EffectEvent;
	
	import spark.components.Image;
	
	import Util.Utiles;

	public class IntentoBean
	{
		private var primeraCelda:CeldaBean;
		
		private var segundaCelda:CeldaBean;
		
		public var isComplete:Boolean;
		
		public function IntentoBean(primeraCelda:CeldaBean):void
		{						
			mostrarCelda(primeraCelda);
			
			Utiles.addIntento();
			
			this.primeraCelda = primeraCelda;
			
			this.isComplete = false;
		}
		
		public function resolverIntento(segundaCelda:CeldaBean):void
		{
			mostrarCelda(segundaCelda);
			
			this.segundaCelda = segundaCelda;
			
			this.isComplete = true;
			
			if(primeraCelda.carta.id == segundaCelda.carta.id)
			{							
				Utiles.soundEnchant.play();
				
				Utiles.addAcierto();
				
				Utiles.borrarIntentoActual();
			}
			else
			{
				setTimeout(ocultarCeldas, 750);					
			}	
		}
		
		private function mostrarCelda(celda:CeldaBean):void
		{
			var imagenCambiada:Boolean = false;			
			Utiles.animarObjeto(celda.imagen, Utiles.EFFECT_ROTATE_SHOW_1_KEY);
			celda.imagen.addEventListener(EffectEvent.EFFECT_END, function(event:EffectEvent):void
			{
				if(!imagenCambiada)
				{
					var image:Image = event.currentTarget as Image;
					image.source = celda.carta.path;
					
					imagenCambiada = true;
					Utiles.animarObjeto(image, Utiles.EFFECT_ROTATE_SHOW_2_KEY);
				}
			});			
		}
		
		private function ocultarCeldas():void
		{
			Utiles.soundMiss.play();
			
			var primeraCambiada:Boolean = false;			
			Utiles.animarObjeto(primeraCelda.imagen, Utiles.EFFECT_ROTATE_HIDE_1_KEY);
			primeraCelda.imagen.addEventListener(EffectEvent.EFFECT_END, function(event:EffectEvent):void
			{
				if(!primeraCambiada)
				{
					var image:Image = event.currentTarget as Image;
					image.source = CartasEnum.CARTA_TRASERA.path;
					
					primeraCambiada = true;
					Utiles.animarObjeto(image, Utiles.EFFECT_ROTATE_HIDE_2_KEY);
				}
			});
			
			var segundaCambiada:Boolean = false;	
			Utiles.animarObjeto(segundaCelda.imagen, Utiles.EFFECT_ROTATE_HIDE_1_KEY);
			segundaCelda.imagen.addEventListener(EffectEvent.EFFECT_END, function(event:EffectEvent):void
			{
				if(!segundaCambiada)
				{
					var image:Image = event.currentTarget as Image;
					image.source = CartasEnum.CARTA_TRASERA.path;
					
					segundaCambiada = true;
					Utiles.animarObjeto(image, Utiles.EFFECT_ROTATE_HIDE_2_KEY);
					
					Utiles.borrarIntentoActual();
				}
			});
		}
	}
}