function load () {
	var canvas = document.querySelector('#paint');
	var ctx = canvas.getContext('2d');
	
	var sketch = document.querySelector('#sketch');
	var sketch_style = getComputedStyle(sketch);
	canvas.width = parseInt(sketch_style.getPropertyValue('width'));
	canvas.height = parseInt(sketch_style.getPropertyValue('height'));
	
	// Creating a tmp canvas
	var tmp_canvas = document.createElement('canvas');
	var tmp_ctx = tmp_canvas.getContext('2d');
	tmp_canvas.id = 'tmp_canvas';
	tmp_canvas.width = canvas.width;
	tmp_canvas.height = canvas.height;
	
	sketch.appendChild(tmp_canvas);

	var mouse = {x: 0, y: 0};
	var start_mouse = {x: 0, y: 0};
	var last_mouse = {x: 0, y: 0};
	
	var tool = 'pencil';
	
	
	// SELECCION HERRAMIENTA
	document.querySelector('#pencil').onchange = function() {
		if (this.checked)
			tool = 'pencil';		
		// Show Tmp Canvas
		tmp_canvas.style.display = 'block';
		actualizar();
		
	};
	document.querySelector('#circle').onchange = function() {
		if (this.checked)
			tool = 'circle';		
		// Show Tmp Canvas
		tmp_canvas.style.display = 'block';		
		actualizar();
		
	};
	document.querySelector('#rectangle').onchange = function() {
		if (this.checked)
			tool = 'rectangle';		
		// Show Tmp Canvas
		tmp_canvas.style.display = 'block';		
		actualizar();
		
	};
	document.querySelector('#eraser').onchange = function() {
		if (this.checked)
			tool = 'eraser';
		// Hide Tmp Canvas
		tmp_canvas.style.display = 'none';
		actualizar();
	};
	
	// Pencil Points
	var ppts = [];
	
	/* Mouse Capturing Work */
	tmp_canvas.addEventListener('mousemove', function(e) {
		mouse.x = typeof e.offsetX !== 'undefined' ? e.offsetX : e.layerX;
		mouse.y = typeof e.offsetY !== 'undefined' ? e.offsetY : e.layerY;
		actualizarColor();
		tmp_ctx.lineWidth = parseInt($('#medida').val());
		ctx.lineWidth = parseInt($('#medida').val());
		if ($('#guardar').val() == "1") {
			$('#guardar').val("0");
			exportToPNG();
		}
	}, false);
	
	canvas.addEventListener('mousemove', function(e) {
		mouse.x = typeof e.offsetX !== 'undefined' ? e.offsetX : e.layerX;
		mouse.y = typeof e.offsetY !== 'undefined' ? e.offsetY : e.layerY;
		actualizarColor();
		tmp_ctx.lineWidth = parseInt($('#medida').val());
		ctx.lineWidth = parseInt($('#medida').val());
		if ($('#guardar').val() == "1") {
			$('#guardar').val("0");
			exportToPNG();
		}
	}, false);
	
	/* Drawing on Paint App */
	tmp_ctx.lineJoin = 'round';
	tmp_ctx.lineCap = 'round';
	actualizar();
	
	function exportToPNG () {
		window.open(canvas.toDataURL());
	}
	
	function actualizarColor () {
		if (tool == 'pencil') {
			tmp_ctx.fillStyle = $('#colorS2').val();
			tmp_ctx.strokeStyle = $('#colorS2').val();
		}
		else if (tool != 'eraser') {
			ctx.globalCompositeOperation = 'source-over';
			tmp_ctx.fillStyle = $('#colorS1').val();
			tmp_ctx.strokeStyle = $('#colorS2').val();
		}
	};
	
	function actualizar() {
		if (tool == 'pencil') {
			//Lapiz
			//alert("Lapiz seleccionado");
			tmp_canvas.addEventListener('mousedown', function(e) {
				tmp_canvas.addEventListener('mousemove', onPaintPincel, false);
				
				mouse.x = typeof e.offsetX !== 'undefined' ? e.offsetX : e.layerX;
				mouse.y = typeof e.offsetY !== 'undefined' ? e.offsetY : e.layerY;
				
				ppts.push({x: mouse.x, y: mouse.y});
				
				onPaintPincel();
			}, false);
			tmp_canvas.addEventListener('mouseup', function() {
				tmp_canvas.removeEventListener('mousemove', onPaintPincel, false);
				
				// Writing down to real canvas now
				ctx.drawImage(tmp_canvas, 0, 0);
				// Clearing tmp canvas
				tmp_ctx.clearRect(0, 0, tmp_canvas.width, tmp_canvas.height);
				
				// Emptying up Pencil Points
				ppts = [];
			}, false);
			var onPaintPincel = function() {
				// Saving all the points in an array
				ppts.push({x: mouse.x, y: mouse.y});
				
				if (ppts.length < 3) {
					var b = ppts[0];
					tmp_ctx.beginPath();
					//ctx.moveTo(b.x, b.y);
					//ctx.lineTo(b.x+50, b.y+50);
					tmp_ctx.arc(b.x, b.y, tmp_ctx.lineWidth / 2, 0, Math.PI * 2, !0);
					tmp_ctx.fill();
					tmp_ctx.closePath();
					
					return;
				}
				
				// Tmp canvas is always cleared up before drawing.
				tmp_ctx.clearRect(0, 0, tmp_canvas.width, tmp_canvas.height);
				
				tmp_ctx.beginPath();
				tmp_ctx.moveTo(ppts[0].x, ppts[0].y);
				
				for (var i = 1; i < ppts.length - 2; i++) {
					var c = (ppts[i].x + ppts[i + 1].x) / 2;
					var d = (ppts[i].y + ppts[i + 1].y) / 2;
					
					tmp_ctx.quadraticCurveTo(ppts[i].x, ppts[i].y, c, d);
				}
				
				// For the last 2 points
				tmp_ctx.quadraticCurveTo(
					ppts[i].x,
					ppts[i].y,
					ppts[i + 1].x,
					ppts[i + 1].y
				);
				tmp_ctx.stroke();
			};
		} else if (tool == 'circle') {
			//Circulo
			//alert("Circulo seleccionado");
			tmp_canvas.addEventListener('mousedown', function(e) {
				tmp_canvas.addEventListener('mousemove', onPaintCirculo, false);
				
				mouse.x = typeof e.offsetX !== 'undefined' ? e.offsetX : e.layerX;
				mouse.y = typeof e.offsetY !== 'undefined' ? e.offsetY : e.layerY;
				
				start_mouse.x = mouse.x;
				start_mouse.y = mouse.y;
				
				onPaintCirculo();
			}, false);
			tmp_canvas.addEventListener('mouseup', function() {
				tmp_canvas.removeEventListener('mousemove', onPaintCirculo, false);
				
				// Writing down to real canvas now
				ctx.drawImage(tmp_canvas, 0, 0);
				// Clearing tmp canvas
				tmp_ctx.clearRect(0, 0, tmp_canvas.width, tmp_canvas.height);
				
			}, false);
			var onPaintCirculo = function() {
			// Tmp canvas is always cleared up before drawing.
			tmp_ctx.clearRect(0, 0, tmp_canvas.width, tmp_canvas.height);
		 
			var x = (mouse.x + start_mouse.x) / 2;
			var y = (mouse.y + start_mouse.y) / 2;
		 
			var radius = Math.max(
				Math.abs(mouse.x - start_mouse.x),
				Math.abs(mouse.y - start_mouse.y)
			) / 2;
		 
			tmp_ctx.beginPath();
			tmp_ctx.arc(x, y, radius, 0, Math.PI*2, false);
			// tmp_ctx.arc(x, y, 5, 0, Math.PI*2, false);
			tmp_ctx.fill();
			tmp_ctx.stroke();
			tmp_ctx.closePath();
			};
		} else if (tool == 'rectangle') {
			//Rectangulo
			//alert("Rectangulo seleccionado");
			tmp_canvas.addEventListener('mousedown', function(e) {
				tmp_canvas.addEventListener('mousemove', onPaintRectangulo, false);
				
				mouse.x = typeof e.offsetX !== 'undefined' ? e.offsetX : e.layerX;
				mouse.y = typeof e.offsetY !== 'undefined' ? e.offsetY : e.layerY;
				
				start_mouse.x = mouse.x;
				start_mouse.y = mouse.y;
				
				onPaintRectangulo();
			}, false);
			tmp_canvas.addEventListener('mouseup', function() {
				tmp_canvas.removeEventListener('mousemove', onPaintRectangulo, false);
				
				// Writing down to real canvas now
				ctx.drawImage(tmp_canvas, 0, 0);
				// Clearing tmp canvas
				tmp_ctx.clearRect(0, 0, tmp_canvas.width, tmp_canvas.height);
				
			}, false);
			var onPaintRectangulo = function() {
				// Tmp canvas is always cleared up before drawing.
				tmp_ctx.clearRect(0, 0, tmp_canvas.width, tmp_canvas.height);
				
				var x = Math.min(mouse.x, start_mouse.x);
				var y = Math.min(mouse.y, start_mouse.y);
				var width = Math.abs(mouse.x - start_mouse.x);
				var height = Math.abs(mouse.y - start_mouse.y);
				tmp_ctx.fillRect(x, y, width, height);
				tmp_ctx.strokeRect(x, y, width, height);
			};
		} else if (tool == 'eraser') {
			//GOMA
			//alert("Goma seleccionado");
			canvas.addEventListener('mousedown', function(e) {
				canvas.addEventListener('mousemove', onErase, false);
					
				mouse.x = typeof e.offsetX !== 'undefined' ? e.offsetX : e.layerX;
				mouse.y = typeof e.offsetY !== 'undefined' ? e.offsetY : e.layerY;
				
				ppts.push({x: mouse.x, y: mouse.y});
				
				onErase();
			}, false);
		
			canvas.addEventListener('mouseup', function() {
				canvas.removeEventListener('mousemove', onErase, false);
				
				// Emptying up Pencil Points
				ppts = [];
			}, false);
		
			var onErase = function() {
			
				// Saving all the points in an array
				ppts.push({x: mouse.x, y: mouse.y});
				
				ctx.globalCompositeOperation = 'destination-out';
				ctx.fillStyle = 'rgba(0,0,0,1)';
				ctx.strokeStyle = 'rgba(0,0,0,1)';
				
				if (ppts.length < 3) {
					var b = ppts[0];
					ctx.beginPath();
					//ctx.moveTo(b.x, b.y);
					//ctx.lineTo(b.x+50, b.y+50);
					ctx.arc(b.x, b.y, ctx.lineWidth / 2, 0, Math.PI * 2, !0);
					ctx.fill();
					ctx.closePath();
					
					return;
				}
				
				// Tmp canvas is always cleared up before drawing.
				// ctx.clearRect(0, 0, canvas.width, canvas.height);
				ctx.beginPath();
				ctx.moveTo(ppts[0].x, ppts[0].y);
				
				for (var i = 1; i < ppts.length - 2; i++) {
					var c = (ppts[i].x + ppts[i + 1].x) / 2;
					var d = (ppts[i].y + ppts[i + 1].y) / 2;
					
					ctx.quadraticCurveTo(ppts[i].x, ppts[i].y, c, d);
				}
				// For the last 2 points
				ctx.quadraticCurveTo(
					ppts[i].x,
					ppts[i].y,
					ppts[i + 1].x,
					ppts[i + 1].y
				);
				ctx.stroke();
			};
		} else {
			alert("La tool no es nada");
		}
	}
};